using System;
using System.Collections.Generic;
using System.Text;

namespace lpcieapi
{
    public class lpcie
    {
        public const string E502_DEVICE_NAME = "E502";
        public const string E16_DEVICE_NAME = "E16";
        /** Коды ошибок библиотеки */
        public enum Errs : int
        {
            /** Функция выполнена без ошибок */
            OK = 0,
            /** В функцию передан недействительный описатель модуля */
            INVALID_HANDLE = -1,
            /** Ошибка выделения памяти */
            MEMORY_ALLOC = -2,
            /** Попытка открыть уже открытое устройство */
            ALREADY_OPENED = -3,
            /** Устройство с заданными параметрами не найдено в системе */
            DEVICE_NOT_FOUND = -4,
            /** Доступ к устройству запрещен (Как правило из-за того, что устройство
                уже открыто в другой программе) */
            DEVICE_ACCESS_DENIED = -5,
            /** Ошибка открытия устройства */
            DEVICE_OPEN = -6,
            /** В функцию передан недействительный указатель */
            INVALID_POINTER = -7,
            /** Функция не может быть выполнена при запущенном потоке сбора данных */
            STREAM_IS_RUNNING = -8,
            /** Ошибка чтения данных синхронного ввода */
            RECV = -9,
            /** Ошибка записи данных для синхронного вывода */
            SEND = -10,
            /** Произошло переполнение внутреннего буфера для потока синхронного ввода */
            STREAM_OVERFLOW = -11,
            /** Неизвестное сообщение в потоке синхронного ввода */
            UNSUP_STREAM_MSG = -12,
            /** Ошибка создания системного мьютекса */
            MUTEX_CREATE = -13,
            /** Неверный описатель мьютекса */
            MUTEX_INVALID_HANDLE = -14,
            /** Истекло время ожидания освобождения мьютекса */
            MUTEX_LOCK_TOUT = -15,
            /** Ошибка освобождения мьютекса */
            MUTEX_RELEASE = -16,
            /** Недостаточно системных ресурсов */
            INSUFFICIENT_SYSTEM_RESOURCES = -17,
            /** Данная возможность еще не реализована */
            NOT_IMPLEMENTED = -18,
            /** Недостаточный размер массива */
            INSUFFICIENT_ARRAY_SIZE = -19,
            /** Ошибка чтения регистра FPGA */
            FPGA_REG_READ = -20,
            /** Ошибка записи регистра FPGA */
            FPGA_REG_WRITE = -21,
            /** Сбор данных уже остановлен */
            STREAM_IS_NOT_RUNNING  = -22,
            /** Ошибка освобождения интерфейса */
            INTERFACE_RELEASE = -23,
            /** Ошибка запуска потока */
            THREAD_START = -24,
            /** Ошибка останова потока */
            THREAD_STOP = -25,
            /** Устройство было отключено */
            DEVICE_DISCONNECTED = -26,
            /** Неверный размер ответа на управляющий запрос */
            IOCTL_INVALID_RESP_SIZE = -27,
            /** Неверный тип устройства */
            INVALID_DEVICE = -28,
            /** Недействительная запись о устройстве */
            INVALID_DEVICE_RECORD = -29,
            /** Неверный хендл конфигурации модуля */
            INVALID_CONFIG_HANDLE = -30,
            /** Связь с устройством закрыта или не была установлена */
            DEVICE_NOT_OPENED = -31,
            /** Данная операция не доступна для текущего интерфейса связи с устройством */
            INVALID_OP_FOR_IFACE = -32,
            /** Не загружен ПЛИС модуля */
            FPGA_NOT_LOADED = -33,
            /** Неверная конфигурация USB-устройства */
            INVALID_USB_CONFIGURATION = -34,
            /** Задан неверный размер логической таблицы */
            INVALID_LTABLE_SIZE = -102,
            /** Задан неверный номер логического канала */
            INVALID_LCH_NUMBER = -103,
            /** Неверно задано значение диапазона АЦП */
            INVALID_LCH_RANGE = -104,
            /** Неверно задан режим измерения для логического канала */
            INVALID_LCH_MODE = -105,
            /** Неверно задан номер физического канала при настройке логического */
            INVALID_LCH_PHY_NUMBER = -106,
            /** Неверно задан размер усреднения для логического канала */
            INVALID_LCH_AVG_SIZE = -107,
            /** Неверно задан делитель частоты сбора данных АЦП */
            INVALID_ADC_FREQ_DIV = -108,
            /** Неверно задан делитель частоты синхронного ввода цифровых линий */
            INVALID_DIN_FREQ_DIV = -109,
            /** Неверно задан режим работы модуля L502 */
            INVALID_MODE = -110,
            /** Неверный номер канала ЦАП */
            INVALID_DAC_CHANNEL = -111,
            /** Неверный код выбора опорной частоты синхронизации */
            INVALID_REF_FREQ = -112,
            /** Неверно задано значение межкадровой задержки */
            INVALID_INTERFRAME_DELAY = -113,
            /** Неверно задан режим синхронизации */
            INVALID_SYNC_MODE = -114,
            /** Неверно задан номер канала DMA */
            INVALID_DMA_CH = -115,
            INVALID_STREAM_CH = -115,
            /** Неверно задан делитель частоты синхронного вывода */
            INVALID_OUT_FREQ_DIV = -116,

            /** Ошибка захвата опорной частоты синхронизации */
            REF_FREQ_NOT_LOCKED = -131,
            /** Управляющий запрос к драйверу завершен с ошибкой */
            IOCTL_FAILD = -132,
            /** Истек таймаут ожидания завершения выполнения управляющего запроса к драйверу */
            IOCTL_TIMEOUT = -133,
            /** Ошибка получения информации о устройстве от драйвера */
            GET_INFO = -134,
            /** За время ожидания не было считано новое слово с цифровых линий */
            DIG_IN_NOT_RDY = -135,
            /** Принято недостаточно слов от модуля */
            RECV_INSUFFICIENT_WORDS = -136,
            /** Попытка выполнить операцию, требующую наличие ЦАП, при его отсутствии */
            DAC_NOT_PRESENT = -137,
            /** Неверный номер канала в обрабатываемом потоке синхронного ввода */
            PROC_INVALID_CH_NUM = -140,
            /** Неверный код диапазона в обрабатываемом потоке синхронного ввода */
            PROC_INVALID_CH_RANGE = -141,
            /** Задан неверный адрес во Flash-памяти */
            FLASH_INVALID_ADDR = -142,
            /** Задан неверный размер блока данных при работе с Flash-памятью */
            FLASH_INVALID_SIZE = -143,
            /** Истек таймаут ожидания завершения записи во Flash-память */
            FLASH_WRITE_TOUT = -144,
            /** Истек таймаут ожидания завершения стирания блока Flash-памяти */
            FLASH_ERASE_TOUT = -145,
            /** Заданная область для стирания Flash-памяти нарушает границу блока в 4 Кбайт */
            FLASH_SECTOR_BOUNDARY = -146,
            /** Не удалось открыть сокет для соединения */
            SOCKET_OPEN = -147,
            /** Превышено время подключения */
            CONNECTION_TOUT = -148,
            /** Соединение закрыто другой устройством */
            CONNECTION_CLOSED_BY_DEV = -149,
            /** Не удалось установить заданный размер буфера сокета */
            SOCKET_SET_BUF_SIZE = -150,
            /** Соединение для передачи данных не установлено */
            NO_DATA_CONNECTION = -151,
            /** Не удалось дождаться сообщения о завершении потока */
            NO_STREAM_END_MSG = -152,
            /** Соединение было сброшено другой стороной */
            CONNECTION_RESET = -153,
            /** Не удалось найти хост с указанным адресом */
            HOST_UNREACHABLE = -154,
            /** Ошибка установления TCP-соединения */
            TCP_CONNECTION_ERROR = -155,

            /** Не удалось открыть файл прошивки BlackFin */
            LDR_FILE_OPEN = -180,
            /** Ошибка чтения из фала прошивки BlackFin */
            LDR_FILE_READ = -181,
            /** Неверный формат файла прошивки BlackFin */
            LDR_FILE_FORMAT = -182,
            /** Используются возможность LDR-файла, недоступные при записи прошивки
                BlackFin по HDMA */
            LDR_FILE_UNSUP_FEATURE = -183,
            /** Неверный стартовый адрес программы в прошивке BlackFin */
            LDR_FILE_UNSUP_STARTUP_ADDR = -184,
            /** Истек таймаут выполнения запроса на чтения/запись памяти BlackFin */
            BF_REQ_TIMEOUT = -185,
            /** Команда для BlackFin все еще находится в процессе обработки */
            BF_CMD_IN_PROGRESS = -186,
            /** Истекло время выполнения управляющей команды процессором BlackFin */
            BF_CMD_TIMEOUT = -187,
            /** Возвращено недостаточно данных в ответ на команду к BlackFin */
            BF_CMD_RETURN_INSUF_DATA = -188,
            /** Истек таймаут ожидания готовности процессора BlackFin к записи прошивки */
            BF_LOAD_RDY_TOUT = -189,
            /** Попытка выполнить операцию для которой нужен сигнальный процессор при
                отсутствии сигнального процессора в модуле */
            BF_NOT_PRESENT = -190,
            /** Неверный адрес памяти BlackFin при записи или чтении по HDMA */
            BF_INVALID_ADDR = -191,
            /** Неверный размер данных, передаваемых с управляющей командой в BlackFin */
            BF_INVALID_CMD_DATA_SIZE = -192
        }        
    }
}
