find_path ( LIBGCRYPT_INCLUDE_DIR gcrypt.h )
find_library ( LIBGCRYPT_LIBRARY NAMES gcrypt )


if(WIN32)
    cmake_policy(VERSION 3.2)

    string(REGEX REPLACE "\\\\" "/" PROGFILES    $ENV{PROGRAMFILES})
    string(REGEX REPLACE "\\\\" "/" PROGFILESX86 $ENV{PROGRAMFILES\(x86\)})

    set(LIBGCRYPT_SEARCH_DIRS ${LIBGCRYPT_ROOT_DIR} ${PROGFILES} ${PROGFILES}/libs ${PROGFILESX86} ${PROGFILESX86}/libs)
    set(LIBGCRYPT_SEARCH_INCLUDE_DIRS ${LIBGCRYPT_SEARCH_DIRS})
    set(LIBGCRYPT_SEARCH_LIBRARY_DIRS ${LIBGCRYPT_SEARCH_DIRS})
    set(LIBGCRYPT_SEARCH_INCLUDE_SUFFIX include libgcrypt/include gcrypt/include)
    if("${CMAKE_C_COMPILER_ID}" STREQUAL "MSVC")
        if(CMAKE_SIZEOF_VOID_P EQUAL 4)
            set(LIBGCRYPT_SEARCH_LIBRARY_DEF_SUFFIX "msvc")
        else(CMAKE_SIZEOF_VOID_P EQUAL 4)
            set(LIBGCRYPT_SEARCH_LIBRARY_DEF_SUFFIX "msvc64")
        endif(CMAKE_SIZEOF_VOID_P EQUAL 4)
    else("${CMAKE_C_COMPILER_ID}" STREQUAL "GNU")
        if(CMAKE_SIZEOF_VOID_P EQUAL 4)
            set(LIBGCRYPT_SEARCH_LIBRARY_DEF_SUFFIX "mingw")
        else(CMAKE_SIZEOF_VOID_P EQUAL 4)
            set(LIBGCRYPT_SEARCH_LIBRARY_DEF_SUFFIX "mingw64")
        endif(CMAKE_SIZEOF_VOID_P EQUAL 4)
    endif("${CMAKE_C_COMPILER_ID}" STREQUAL "MSVC")
    set(LIBGCRYPT_SEARCH_LIBRARY_SUFFIX   "lib/${LIBGCRYPT_SEARCH_LIBRARY_DEF_SUFFIX}"
                                          "libgcrypt/lib/${LIBGCRYPT_SEARCH_LIBRARY_DEF_SUFFIX}"
                                          "gcrypt/lib/${LIBGCRYPT_SEARCH_LIBRARY_DEF_SUFFIX}")
else(WIN32)
    find_package(PkgConfig QUIET)
    pkg_check_modules(LIBGCRYPT_PKG QUIET libgcrypt)

    set(LIBGCRYPT_SEARCH_INCLUDE_DIRS  ${LIBGCRYPT_PKG_INCLUDE_DIRS} include local/include)

    if(CMAKE_SIZEOF_VOID_P EQUAL 4)
        set(LIBGCRYPT_SEARCH_LIBRARY_DIRS lib local/lib lib/i386-linux-gnu)
    else(CMAKE_SIZEOF_VOID_P EQUAL 4)
        set(LIBGCRYPT_SEARCH_LIBRARY_DIRS lib64 lib/x86_64-linux-gnu local/lib64)
    endif(CMAKE_SIZEOF_VOID_P EQUAL 4)
endif(WIN32)



find_path(LIBGCRYPT_INCLUDE_DIR NAMES gcrypt.h
   PATHS
   ${LIBGCRYPT_SEARCH_INCLUDE_DIRS}
   PATH_SUFFIXES ${LIBGCRYPT_SEARCH_INCLUDE_SUFFIX}
)

find_library(LIBGCRYPT_LIBRARY NAMES gcrypt
   PATHS
   ${LIBGCRYPT_SEARCH_LIBRARY_DIRS}
   PATH_SUFFIXES ${LIBGCRYPT_SEARCH_LIBRARY_SUFFIX}
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(Libgcrypt
        REQUIRED_VARS LIBGCRYPT_LIBRARY LIBGCRYPT_INCLUDE_DIR
        )

if(LIBGCRYPT_FOUND)
    set(LIBGCRYPT_LIBRARIES ${LIBGCRYPT_LIBRARY})
    set(LIBGCRYPT_INCLUDE_DIRS ${LIBGCRYPT_INCLUDE_DIR})
endif(LIBGCRYPT_FOUND)
