Метки времени в потоке данных (только для E502-P1){#sect_tstp_descr}
==============================================================
  Режим синхронизации времени по протоколу PTP  {#sect_ptp_descr}
  ==============================================================
В модификации E502-P1 добавлен механизм внутренних часов с возможностью их плавной подстройки.
Также добавлена поддержка протокола PTP для синхронизации времени по сети Ethernet и реализована возможность вставки меток времени в поток данных "на ввод", 
Таким образом при включении меток времени появилась возможность вычислять точное время для конкретных слов из потока.
E502-P1 поддерживает только Peer-to-Peer режим протокола PTP, поэтому сервер реального времени с которым происходит синхронизация должен быть настроен именно на этот режим.
В режиме PTP Peer-to-Peer каждый узел сети (в т.ч. коммутаторы) должен быть PTP - совместимым и учитывать задержку до ближайшего соседнего, иначе работа PTP синхронизации не возможна.

Если все условия для работы PTP соблюдены, то синхронизация внутреннего значения времени (внутренних часов) в E502-P1 должна заработать автоматически, устройство будет получать значение точного времени с сервера и корректировать внутренние часы.

Для того чтобы метки времени появились в потоке "на ввод", необходимо специально включить такой режим через соотвтствующее API, по умолчанию этот режим выключен.

Для работы с PTP в E502-P1 были добавлены несколько новых регистров.
Ранее зарезервированный бит в слове "на ввод" теперь означает что слово является меткой времени и для нее вводится признак "захват PTP".

Признак "захват PTP" - атрибут слова метки времени, означает что для потока слов полученных между двумя метками времени с установленным признаком захвата можно вычислить время каждого слова с определенной точностью.

Для обеспечения требуемой точности синхронизации в E502-P1 введены несколько настроек.

- <B>Допустимая рассинхронизация часов, +-нс/с.</B>
При каждом получении значения точного времени от сервера, E502-P1 вычисляет разность значения внутренних часов со значением принятым от сервера. Далее эта разность делится на время прошедшее после последней синхронизации (вычисленное по внутренним часам).
Вычисленное значение сравнивается с заданным параметром. Синхронизация считается успешной, если вычисленное значение не выходит за заданный интервал.

- <B>Минимальное кол-во успешных синхронизаций.</B>
Для того чтобы признак "захват PTP" появился, должно произойти минимальное количество успешных синхронизаций.
В случае неудачной синхронизации, признак "захват PTP" сбрасывается и цикл ожидания минимального количества успешных синхронизаций повторяется.


 Работа с модулем при использовании меток времени {#sect_gen_ptp_in}
 ----------------------------------------------------------
 
 Работа с метками времени из API реализована отдельно от функций управления потоком и функций получения данных из потока.
 
 1. Включение вставки меток времени в поток данных "на ввод": X502_FpgaRegWrite(hnd, E502_REGS_ARM_TIME_CTRL, 1);
 2. Установка настроек захвата:  X502_FpgaRegWrite(hnd, E502_REGS_PTP_LOCK_LIMIT, (ptp_limit_ns & 0xffff) | (ptp_req_hits << 16))
 2. Узнать состояние признака "захват PTP": X502_FpgaRegRead(E502_REGS_ARM_TIME_CTRL, &status);
 3. Инициализировать контекст для обработки меток времени: X502_tstp_init(&tstp_state, adc_freq, din_freq).
 4. Обработка меток времени из прочитанных данных с помощью X502_tstp_process_wrd(&tstp_state, cur_wrd), где cur_wrd - очередное слово полученное с помощью X502_Recv()
 

Описание регистров PTP
  -------------------------------------------
  E502_REGS_ARM_TIME_CTRL
  
  Address: 0x110

| Bit     | `Name                      ` | Access | Description                           | Reset<br>Value |
|---------|----------------------------|--------|---------------------------------------|-------------|
| [1] | STATUS | R   | признак "захват PTP"<br>1: признак "захват PTP" присутствует, условия захвата выплнены<br>0: признак "захват PTP" отсутствует | 0           |
| [0] | ENABLE | RW| 1: добавлять метки времени в поток ввода<br>0: поток ввода без меток времени | 0           |

  E502_REGS_PTP_LOCK_LIMIT
  
  Address: 0x706

| Bit     | `Name                      ` | Access | Description                           | Reset<br>Value |
|---------|----------------------------|--------|---------------------------------------|-------------|
| [31:16] | ENABLE | RW     | Минимальное кол-во успешных синхронизаций | 0           |
| [15:0]  | STATUS  | R      | Допустимая рассинхронизация часов, +-нс/с                 | 0           |


PTP-совместимое оборудование
  -------------------------------------------

Оборудование, совместная работа которого с E502-P1 по протоколу PTP была проверена.

Сервер времени: блок коррекции времени ЭНКС-2 производства ООО «Инженерный центр „Энергосервис“» (www.enip2.ru)
Сетевой коммутатор с поддержкой PTP: блок L-VIMS-SWITCH производства ООО "Л КАРД" (www.lcard.ru)
