#ifdef _WIN32
    #include <locale.h>
    #include <conio.h>
#else
    #include <signal.h>
    #include <string.h>
    #include <sys/time.h>
    #include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdio.h>

#include "x502api.h"
#include "dev_funcs.h"

#ifdef _WIN32
    #define sleep Sleep
#endif

int main(int argc, char **argv) {
    t_x502_hnd hnd;

    /********** Получение списка устройств и выбор, с каким будем работать ******************/
    hnd = select_dev_from_list(argc, argv, 0);

    /********************************** Работа с модулем **************************/
    /* если успешно выбрали модуль и установили с ним связь - продолжаем работу */
    if (hnd != NULL) {
        uint16_t val = 0x5555;

        for (int i = 0; i < 10; i++) {
            fprintf(stderr, "Выводим значение %x digout\n", val);
            X502_AsyncOutDig(hnd, val, 0);
            val = (val << 1) | (val >> 15);

            sleep(1);
        }
        /* закрываем связь с модулем */
        X502_Close(hnd);
        /* освобождаем описатель */
        X502_Free(hnd);
    }

    return 0;
}
