Работа модуля в режиме с сигнальным процессором{#sect_dsp_firm_setup}
=================================================

Данный раздел относится как к модулю L502, так и E502, т.к. они идентичны с точки зрения сигнального процессора. Все названия в штатной прошивке сигнального процессора идут с префиксом L502 только потому, что данный модуль появился раньше.

Данный раздел предназначен для программистов, которые будут писать свою прошивку сигнального процессора BlackFin.  Для таких программистов "Л Кард" предоставляет штатную прошивку, которая выполняет те же функции, что доступны в режиме без сигнального процессора. То есть в стандартной прошивке реализовано:
- Инициализация всей необходимой периферии
- Обработка стандартных команд, переданных от ПК (настройка параметров сбора, запуск или останов потоков данных и т.п.)
- Прием потока данных АЦП/DIN от ПЛИС  по SPORT0 с последующей передачей этих же данных по HDMA в ПЛИС для передачи в  ПК.
- Прием по HDMA потока данных ЦАП/DOUT и передача этих же данных в ПЛИС по SPORT0 для вывода.

Дальнейшее описание будет основано на штатной прошивке и работа сигнального процессора будет описана на основе реализованных функций из нее.

Исходный код прошивки входит в состав [\"L-Card PCI Express SDK\"](http://www.lcard.ru/download/lpcie_setup.exe)) (устанавливается в папку firmware, если была включена установка файлов для разработчика), а также доступен в виде [репозитория на bitbucket.org](https://bitbucket.org/lcard/l502_blackfin/overview) или его можно взять из [архива исходных кодов SDK](http://bitbucket.org/lcard/lpcie_sdk/downloads/lpcie_sdk_src.zip). 

В штатной прошивке есть файл l502_user_process.c, в котором реализованы функции, вызываемые при приеме или завершении передачи блока данных, а также при приходе пользовательских команд от ПК. Подразумевается, что в простейшем случае пользователю будет достаточно изменить именно этот файл при добавлении своей обработки, если общая концепция штатной прошивки удовлетворяет задаче. По крайней мере именно такой вариант изменения следует рассмотреть в первую очередь.

Сама штатная прошивка может быть собрана как в среде <B>VisualDSP</B>, так и с помощью бесплатного компилятора <B>GCC</B> (с использованием GNU Toolchain для BlackFin).

Информацию о том, как работает периферия сигнального процессора ADSP-BF523, можно узнать из [Hardware Manual](http://www.analog.com/static/imported-files/processor_manuals/BF52xHRM_Rev.1.0.pdf). Данное описание предполагает, что читатель знаком с информацией, изложенной в указанном документе.


Загрузка и запуск прошивки BlackFin{#sect_dsp_load}
=================================================
При включении питания компьютера сигнальный процессор находится в сброшенном состоянии (сброс процессора после подачи питания необходим, чтобы перевести его в известное начальное состояние), а модуль работает в режиме работы без сигнального процессора.

После загрузки драйвера модуля L502 (на одной из стадий загрузки операционной системы), драйвер сразу снимает сигнал сброса в обнаруженных модулях с помощью бита \f$ $\bitref{BfRst}{BF\_RST}$ \f$ регистра \f$ $\regref{BfCtl}{BF\_CTL}$ \f$. В E502 данное действие выполняет ARM-контроллер модуля. После снятия сигнала сброса, начинает выполняться внутренний загрузчик BlackFin, который ожидает прошивку по интерфейсу HostDMA. Также после снятия сброса процессор становится доступен для управления по интерфейсу JTAG.

При этом требуемые настройки частоты клока сигнального процессора и памяти SDRAM хранятся во внутренней специальной памяти (OTP-память). Таким образом, встроенный загрузчик уже инициализирует SDRAM и частоту клока (используется частота ядра 530 МГц и частота периферии SCLK = 132.5 МГц). Это позволяет при необходимости загружать прошивку сразу в SDRAM как по HostDMA, так и через JTAG, без специального инициализационного кода.

Следует также отметить, что до загрузки прошивки интерфейс HostDMA инициализирован только на запись, а инициализация на чтение происходит уже при запуске самой прошивки.

После того, как сигнал сброса снят, необходимо загрузить прошивку сигнального процессора и перевести модуль в DSP-режим.

Загрузка прошивки может быть осуществлена двумя способами:
        - Штатным образом --- из .ldr файла с компьютера по интерфейсу HostDMA
        - Отладочный режим --- загрузка программы через JTAG-интерфейс для последующей отладки.

При использовании штатной библиотеки x502api для загрузки прошивки с компьютера достаточно установить связь с устройством и вызвать функцию  `X502_BfLoadFirmware()`, которая загружает прошивку, проверяет ее работу с помощью команды #L502_BF_CMD_CODE_GET_PARAM с параметром #L502_BF_PARAM_FIRM_VERSION (подробнее смотри раздел @ref sect_bf_cmd), передает прошивке необходимую информацию о модуле, после чего переводит модуль в режим работы с DSP.

Для загрузки через JTAG, необходимо подключить JTAG-эмулятор для процессора BlackFin к специальному разъему на плате (смотри [\"Руководство пользователя L-502\"](http://www.lcard.ru/download/l-502_users_guide.pdf) или [\"Руководство пользователя E-502\"](http://www.lcard.ru/download/e-502_users_guide.pdf)). После этого следует загрузить свой проект по JTAG интерфейсу через эмулятор из среды программирования (описано в следующих двух разделах). Когда прошивка будет загружена и запущена, нужно явно перевести модуль в режим работы с DSP. При использовании прошивки, которая совместима с штатной в плане стандартных команд, для этого можно использовать функцию `X502_BfCheckFirmwareIsLoaded()`, которая проверяет, загружена ли прошивка с помощью команд для получения информации о состоянии прошивки, передает прошивке информацию о модуле и переводит модуль в DSP-режим. Чтобы просто перевести модуль в DSP-режим без каких-либо дополнительных действий, можно воспользоваться функцией `X502_SetMode(X502_MODE_DSP)`.


Сборка и отладка проекта в VisualDSP {#sect_prj_vdsp}
=====================================================
В первую очередь необходимо скачать и установить среду VisualDSP 5.0. Оценочную бесплатную версию можно скачать [с официального сайта Analog Devices](http://www.analog.com/en/processors-dsp/Blackfin/vdsp-bf-sh-ts/products/software-tools-upgrades/visualdsp_tools_upgrades/resources/fca.html#vdsp50). Крайне рекомендуется устанавливать последние обновления (на момент написания документа - 10.1). Все необходимые драйвера для JTAG-эмулятора (если Вы используете эмулятор от Analog Devices) уже устанавливаются вместе со средой.

Все файлы исходников прошивки, специфичные для сборки в среде VisualDSP, лежат в директории l502-bf/vdsp, включая проект для этой среды --- l502-bf.dpj.

Для сборки после установки среды отрываем файл проекта.

\image latex vdsp_prj.png "Проект прошивки в VisualDSP" width=1\textwidth
\image html vdsp_prj.png "Проект прошивки в VisualDSP"

В проекте есть две конфигурации - Debug (с отключенной оптимизацией --- для отладки) и Release (с оптимизацией для финальной версии).
Для отладки через JTAG нужно скомпилировать исходный код в файл .dxe, для чего в "Project->Project Options..." нужно выбрать "Type: Executable".
Чтобы получить файл .ldr для загрузки по HostDMA через `X502_BfLoadFirmware()` нужно будет выбрать "Type: Loader Type".

\image latex vdsp_output_type.png "Настройка типа проекта" width=0.65\textwidth
\image html vdsp_output_type.png "Настройка типа проекта"

Проект может быть собран через "Project->Build Project".

Для отладки необходимо создать сессию через "Session->New Session...".

Выбираем процессор ADSP-BF523, на следующей вкладке выбираем Emulator, далее выбираем нужный JTAG-Эмулятор. Работа проверялась на [ADI ICE 100B](http://docs.blackfin.uclinux.org/doku.php?id=hw:jtag:ice100b). 

После этого, если все подключено и настроено правильно, прошивка будет загружена в сигнальный процессор и остановлена в начале главной функции main() для дальнейшей отладки.

\image latex vdsp_session_processor.png "Выбор процессора для отладочной сессии" width=0.65\textwidth
\image html vdsp_session_processor.png "Выбор процессора для отладочной сессии"

\image latex vdsp_session_con_type.png "Выбор типа подключения отладочной сессии" width=0.65\textwidth
\image html vdsp_session_con_type.png "Выбор типа подключения для отладочной сессии"

\image latex vdsp_session_jtag.png "Выбор JTAG-эмулятора отладочной сессии" width=0.65\textwidth
\image html vdsp_session_jtag.png "Выбор JTAG-эмулятора для отладочной сессии"

\image latex vdsp_debug.png "Отладка прошивки в VisualDSP" width=1\textwidth
\image html vdsp_debug.png "Отладка прошивки в VisualDSP"
