Режим работы с сигнальным процессором{#sect_dsp_mode}
=================================================

Используемая периферия процессора{#init_periph}
=================================================

Перед штатной работой прошивки выполняется инициализация всей используемой периферии. Инициализация реализована в функции l502_init() в файле l502_init.c, которая внутри себя вызывает процедуры инициализации для каждого программного блока из других файлов.

Как уже было описано в разделе @ref sect_dsp_load, инициализация PLL и SDRAM в штатном режиме выполняется уже загрузчиком значениями из OTP-памяти. В l502_init() проверяется, что эти значения есть в OTP-памяти, и, если их не окажется, то устанавливает PLL и SDRAM напрямую и записывает нужные настройки в OTP-память (то есть реально это происходит только во время первого запуска, который выполняется уже при наладке изделия в "Л Кард").

Далее при инициализации настраиваются следующие периферийные узлы сигнального процессора:

Периферия | Режим                                           | Назначение 
----------|-------------------------------------------------|----------------
SPI       | CLK=33.125 МГц, Мастер, 16 бит, CPHA=0, CPOL=0, MSB first  | Запись и чтение содержимого регистров \f$ $\hyperref[tab:regIoHard]{IO\_HARD}$ \f$  и \f$ $\hyperref[tab:regIoArith]{IO\_ARITH}$ \f$ ПЛИС
SPORT0    | CLK=66.25 МГц, внутренний; TFS внешний, активный единицей, ранний; 16-бит, 2 канала, MSB first | Прием данных от АЦП и DIN, передача отсчетов ЦАП и DOUT. Как на прием, так и на передачу используется 2 канала (Primary и Secondary)
HostDMA   | 16 бит, Acknowledge Mode, Burst                 | Прямой доступ к памяти BlackFin со стороны ПЛИС как для передачи команд от ПК, так и для приема/записи потоков данных
PF14, PF15, PG5, PG6 | Выходы                                  | Управление потоком данных по HostDMA на запись и чтение
DMA1      | Настраивается дескриптором от ПЛИС              | Передача данных по HostDMA
DMA3      | Через регистры, автобуфер, 2D, 16 бит, SYNC     | Запись принятых данных от АЦП/DIN по SPORT0 в память BlackFin
DMA4      | Список дескрипторов (small), NDSIZE=5, 16 бит, SYNC | Передача данных из памяти BlackFin в SPORT0



В штатной прошивке используются следующие вектора прерываний (не все из них соответствуют настройкам по-умолчанию!):

Прерывание  | Периферия        | Описание
------------|------------------|----------
IVG7        | DMA3 (SPORT0 RX) | Завершение приема по DMA данных из интерфейса SPORT0
IVG9        | DMA4 (SPORT0 TX) | Завершение передачи по DMA данных в интерфейс SPORT0
IVG10       | HostDMA Read     | Завершение операции чтения по HostDMA
IVG11       | HostDMA Write    | Завершение операции записи по HostDMA


Распределение памяти сигнального процессора{#dect_dsp_mem}
=================================================
Для хранения данных процессору BlackFin доступно два банка внутренней памяти по 32 КБайта и 32 MБайт внешней памяти SDRAM (Подробнее о адресном пространстве процессора ADSP-BF523 см. [Hardware Manual](http://www.analog.com/static/imported-files/processor_manuals/BF52xHRM_Rev.1.0.pdf), главу 3 Memory).

Большую часть памяти можно использовать по своему усмотрению, однако есть часть фиксированных адресов в начале первого банка внутренней памяти (начиная с адреса 0xFF800000).

Для этой области выделена специальная секция в файле линкера ('board_state') размером 8 КБайт. В эту секцию помещена структура #g_state типа #t_l502_board_state.

Область адресов 0xFF800000-0xFF8007FF используется для хранения дескрипторов DMA при передаче потока данных из BlackFin в персональный компьютер и обратно через интерфейс HostDMA. Эти адреса заданы в логике работы ПЛИС и всегда должны быть использованы по этому назначению.

Остальная часть фиксированной области памяти используется для передачи команд от ПК через интерфейс HostDMA. Взаимодействие штатной прошивки BlackFin и ПО персонального компьютера осуществляется через специальный командный интерфейс, который подробнее описан в разделе @ref sect_bf_cmd.

Остальную область памяти программист может использовать по своему усмотрению.
В штатной прошивке внешняя память SDRAM используется для буферов данных, в то время как все переменные хранятся во внутренней памяти для быстрого доступа. При таком варианте кеш-память, соответственно, не используется.

Следует также учитывать, что при создании больших буферов, начальное значение которых не важно, следует помещать их в секции неинициализируемой памяти, чтобы при заливке прошивки не приходилось загружать эти большие буфера. В штатной прошивке для этого в файле линкера создана специальная секция во внешней SDRAM. К сожалению, в VisualDSP можно указать, что секция находится в неинициализируемой области только через \#pragma section(секция, NO_INIT), и нельзя сделать независимый от компилятора \#define. Указание того, что массив должен быть в неинициализируемой области SDRAM выполняется с помощью включения файла, в котором объявлена нужная директива для компилятора. В примере ниже это используется для объявления буфера для приема данных по SPORT0 (АЦП/DIN) в файле l502_stream.c. Реально при сборке на VisualDSP включается файл "vdsp/l502_sdram_noinit.h", а при сборке GCC --- "gcc/l502_sdram_noinit.h". Включать файл нужно строго перед каждой переменной, которую необходимо поместить в неинициализируемую область 
SDRAM:
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.c}
  #include "l502_sdram_noinit.h"
  static volatile uint32_t f_sport_in_buf[L502_SPORT_IN_BUF_SIZE];
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Интерфейс HostDMA{#sect_hdma}
==================================================================
Интерфейс HostDMA предоставляет прямой доступ к памяти сигнального процессора BlackFin извне. При этом доступ может быть осуществлен как во внутреннюю память L1, так и во внешнюю SDRAM (доступа к регистрам ядра и периферии по HostDMA нет).

Интерфейс HostDMA в модуле L502 используется для следующих целей:
- Прямой доступ к памяти BlackFin со стороны ПК через регистры PCI блока управления DSP в ПЛИС. В частности через доступ к фиксированной области памяти реализован командных интерфейс между ПК и сигнальным процессором (см. раздел @ref sect_bf_cmd).
- Прямой доступ к памяти BlackFin со стороны блока DMA ПЛИС для осуществления передачи потоков данных между памятью сигнального процессора и памятью ПК. Подробнее этот механизм описан в разделе @ref sect_hdma_stream.

<B> Важно! </B> Запись и чтение по HostDMA всегда осуществляются блоками, кратными восьми 32-битным словам (32 байта). Таким образом при записи массива данных размером, некратным размеру блока, будет испорчена часть данных за записываемой частью до границы, кратной 32-м байтам. При чтении некратного размера также реально читается кратный блок большего размера, лишние данные из которого потом откидываются. Однако и при чтении и при записи некратных блоков необходимо, чтобы все реально читаемые или записываемые адреса кратного блока относились к действительной памяти сигнального процессора!

По завершению обмена одного блока данных по интерфейсу HostDMA в сигнальном процессоре вызывается прерывание. Для обработки завершения чтения используется обработчик hdma_rd_isr(), а для завершения записи hdma_isr(). При этом следует учитывать, что если эти обработчики не выполнят необходимые действия по завершению передачи блока, то следующий обмен по HostDMA не будет разрешен. Таким образом, интерфейс HostDMA в BlackFin не является полностью независимым от прошивки сигнального процессора и, если программа, например, остановлена на точке останова, то в это время обмен по HostDMA может не выполнится.

Для прямого доступа к памяти со стороны ПК в библиотеке l502api введены функции `X502_BfMemRead()` и `X502_BfMemWrite()`. При этом реально обмен осуществляется блоками с максимальным размером 128 32-битных слов (512 байт), т.е. при вызове функции с большим размером, массив данных будет разбит на несколько блоков, которые будут последовательно записаны/прочитаны. 

При этом необходимо знать, что находится по адресам, к которым выполняется прямой доступ, и правильно распределять право доступа к разделяемой между ПК и сигнальным процессором памятью, чтобы не допускать чтение частично измененного блока памяти или одновременное изменение блока памяти как со стороны ПК, так и со стороны прошивки BlackFin. В штатной прошивке прямой доступ используется исключительно для организации командного интерфейса, который описан в [следующем разделе](@ref sect_bf_cmd).


Командный интерфейс между ПК и сигнальным процессором{#sect_bf_cmd}
==================================================================

Как уже отмечалось, управление сигнальным процессором с ПК осуществляется через интерфейс HostDMA, который предоставляет прямой доступ к памяти сигнального процессора.

В памяти сигнального процессора, начиная с адреса 0xFF800800, выделена специальная область, которая используется для передачи управляющих команд от ПК к сигнальному процессору.
Все управление сигнальным процессором в штатной прошивке выполняется с помощью командного интерфейса, описанного в данной главе.
Реализация обработки команд содержится в файле l502_cmd.c

Структура фиксированной области памяти, использующейся для передачи команд, описана с помощью типа #t_l502_bf_cmd, а доступ к ней можно получить с помощью поля cmd глобальной переменной #g_state.

Каждая команда характеризуется:
  - Кодом команды, который собственно определяет, какое действие должно выполняться
  - 32-битным параметром команды, который уточняет назначение команды. Его интерпретация полностью зависит от кода команды.
  - Данными, переданными с командой (от 0 до #L502_BF_CMD_DATA_SIZE_MAX 32-битных слов)

По завершению обработки команды прошивка сигнального процессора возвращает:
  - Код завершения команды (0 при успехе, код ошибки при неудаче)
  - Данные результата (от 0 до #L502_BF_CMD_DATA_SIZE_MAX 32-битных слов).

 Для проверки, выполняется ли сейчас команда, в #t_l502_bf_cmd определено поле статуса команды.
 Выполнение команды осуществляется следующим образом:
  - Изначально статус команды равен #L502_BF_CMD_STATUS_IDLE (или #L502_BF_CMD_STATUS_DONE, если до этого уже была выполнена команда)
  - При необходимости передать команду в DSP программа ПК записывает в фиксированную область все параметры команды. При этом при последней операции записи в поле статуса записывается значение #L502_BF_CMD_STATUS_REQ. Т.е. поле статуса записывается не обязательно самым последним, главное что статус изменяется при  записи последнего блока по HostDMA. Поэтому проверка статуса команды выполняется именно из обработчика, когда блок полностью записан, а не из произвольного места в прошивке BlackFin.
  - В обработчике прерывания на завершения записи по HostDMA hdma_isr() проверяется статус команды. В случае если он равен #L502_BF_CMD_STATUS_REQ, то вызывается функция l502_cmd_set_req(), которая устанавливает статус в #L502_BF_CMD_STATUS_PROGRESS и устанавливает флаг о том, что пришла команда.
  - В основной программе периодически проверяется этот флаг через l502_cmd_check_req(). Если флаг установлен, то вызывается l502_cmd_start(), в которой начинается обработка команды. Таким образом, сама обработка команды выполняется не из обработчика прерываний. Функция l502_cmd_start() анализирует код команды и вызывает соответствующий обработчик команды. Для штатных команд существует таблица соответствия кодов команд и обработчиков. Для кодов команд больше или равных #L502_BF_CMD_CODE_USER вызывается пользовательский обработчик usr_cmd_process(). Именно эти коды должен использовать пользователь, если хочет сохранить совместимость с штатной прошивкой.
  - Обработчик может обработать команду сразу или отложить ее выполнение на потом, установив например специальный флаг о необходимости завершения и сразу вернув управление.
  - По завершению обработки вызывается l502_cmd_done(), которая устанавливает переданный ей код результата, копирует переданные данные в g_state.cmd.data (если они уже не там), устанавливает их размер в g_state.cmd.data_size и в последнюю очередь устанавливает статус равным #L502_BF_CMD_STATUS_DONE. Следует следить, чтобы на каждую команду была вызвана l502_cmd_done(). В противном случае программа ПК не сможет дождаться завершения команды.
  - Программа ПК периодически читает состояние команды. Когда оно станет #L502_BF_CMD_STATUS_DONE, программа определяет, что обработка команды завершена и считывает ее результат.
  - После этого программа ПК может передавать следующую команду.

Таким образом, одновременно может выполняться только одна команда. При этом для правильного функционирования интерфейса команд необходимо чтобы как программа на ПК, так и программа сигнального процессора соблюдали правила доступа к разделяемой структуре g_state.cmd и изменяли ее только в те моменты, когда доступ находится у соответствующей программы:
  - Изначально доступ к параметром команды находится у ПК и программа ПК может в любой момент передать команду
  - После установки поля статуса команды в #L502_BF_CMD_STATUS_REQ, доступ к структуре переходит в собственность прошивки сигнального процессора и она может менять ее содержимое по своему усмотрению до завершения обработки
  - После установки прошивкой статуса команды в #L502_BF_CMD_STATUS_DONE (из l502_cmd_done()) доступ снова переходит к программе ПК, и она может передавать следующую команду.
  
Штатные команды используются штатной библиотекой l502api внутри стандартных функций, когда модуль находится в DSP режиме. Они соответствуют назначению стандартных функций (установка параметров сбора, запуск, останов синхронного сбора данных, разрешение/запрещение синхронных потоков и т.д.). Пользователь может добавить в прошивку свои команды. Для выполнения пользовательских команд в библиотеке l502api введена функция `X502_BfExecCmd()`. Для совместимости с штатной прошивкой рекомендуется пользователю добавлять свои команды с кодом  #L502_BF_CMD_CODE_USER или выше, так как в этом случае пользовательские команды не будут пересекаться с штатными (если будут введены новые) и на эти коды всегда вызывается функция usr_cmd_process(), что позволяет не изменять основную прошивку. 


Передача потоков данных между ПК и сигнальным процессором по интерфейсу HostDMA{#sect_hdma_stream}
==================================================================
Через HostDMA также передаются потоки данных от ПК в сигнальный процессор и от сигнального процессора в ПК. Как было уже сказано до этого, направление потока данных определяется относительно ПК (поток ввода IN  --- АЦП/DIN -> FPGA -> SPORT0 -> BlackFin -> HDMA -> FPGA -> PC, а поток вывода OUT --- PC -> FPGA -> HDMA -> BlackFin -> SPORT0 -> FPGA -> ЦАП/DOUT). При этом названия send, recv в функциях даны относительно DSP.

Помимо самого интерфейса HostDMA, для управления потоком дополнительно используются 4 ножки общего назначения (настроенные как выход).

Выводы PF14 и PF15 используются для запрещения/разрешения передачи потока на ввод и вывод соответственно. Когда на них выставлена "1", то в ПЛИС автомат, ответственный за передачу потока данного направления, находится в состоянии сброса. Передача в этом направлении не ведется. Все поставленные в очередь передачи по HostDMA очищаются (однако если идет в данный момент передача блока по HostDMA, то она завершается до конца, так как разрывать передачу посередине нельзя).

Выводы PG5 и PG6 используются, чтобы сообщить ПЛИС о том, что BlackFin готов передавать или принимать блок данных соответственно. Изменение состояния этих выходов (toggle) при нулевом значении на выходах PF14 или PF15 является признаком, что в памяти BlackFin есть готовый новый блок для передачи или есть место для приема очередного блока на вывод. При этом можно сообщить о готовности нового блока до завершения предыдущего, так как ПЛИС сохраняет количество готовых, но не завершенных запросов на обмен. Всего может быть до 31 (определено через #L502_IN_HDMA_DESCR_CNT и #L502_OUT_HDMA_DESCR_CNT) незавершенных запросов по каждому направлению.

Для описания запросов на обмен используются дескрипторы, которые хранятся в фиксированной области памяти BlackFin (`g_state.hdma.in[]` и `g_state.hdma.out[]`). Состав дескриптора описан типом #t_hdma_stream_descr. Каждый дескриптор содержит следующую информацию:
- Полный размер передачи в 16-битных словах
- Адрес буфера в памяти BlackFin из которого данные должны быть переданы или в который должны быть записаны
- Размер непрерывного блока передачи в 16-битных словах! (см. ниже)
- Модификатор указателя (на сколько изменяется адрес при передачи очередного 16-битного слова, для непрерывной передачи равен 2)
- Адрес следующего дескриптора
- Флаги (сейчас определен только один флаг - #L502_HDMA_FLAGS_SEND_LAST)
- id дескриптора (используется только для проверки, какой дескриптор завершен)
- valid - признак действительности дескриптора (используется только для проверки завершения)

После сброса автомата ПЛИС ножками PF14 и PF15, автомат ожидает дескриптор по фиксированным адресам: &g_state.in[0] (0xFF800020)  для ввода и &g_state.out[0] (0xFF800420) для вывода. Адрес же каждого следующего дескриптора задается в предыдущем дескрипторе.

По завершению чтения или записи данных, соответствующих дескриптору, ПЛИС записывает обработанный дескриптор полностью обратно в память BlackFin по адресам &g_state.in_lb (0xFF800000) и &g_state.out_lb (0xFF800400).
При записи назад обработанного дескриптора изменяются следующие поля:
- поле адреса указывает на адрес за последним переданным словом
- поле full_size указывает, сколько осталось передать данных в 16-битных словах (0, если все передано)
- остальные поля сохраняются без изменений

Прошивка использует поле valid, чтобы узнать о завершении запроса. Изначально g_state.in_lb.valid и g_state.out_lb.valid равны нулю. В передаваемых дескрипторах поле valid установлено в единицу. Таким образом, если в g_state.in_lb.valid или g_state.out_lb.valid станет равен единице после завершения записи по HostDMA, то это означает что блок данных, соответствующий дескриптору был передан (если его full_size стал равен нулю).

Один запрос может выполняться за несколько передач. Именно для этого введено поле xcnt в дополнение к full_size. Дело в том, что одна передача по HostDMA не может быть прервана другой, поэтому при использовании больших размеров передач шина будет занята надолго одной передачей и не будет доступна для других. Кроме того, сама передача не начинается, пока во внутреннем буфере DMA в ПЛИС не будет достаточно места (чтобы не получилось, что передача остановлена на середине из-за того, что нет места во внутреннем буфере). При этом, если на каждый небольшой блок автомат ПЛИС будет должен  прочитать дескриптор, выполнить обмен и записать дескриптор снова для оповещения о завершении --- это приведет к большим дополнительным расходам пропускной способности HostDMA. Таким образом, один дескриптор может описывать задачу на передачу большого блока данных (=full_size), в то время как ПЛИС разобьет их на несколько передач (размер каждой соответствует xcnt). full_size не обязательно должен быть кратен xcnt, так как ПЛИС может
выполнить последний обмен меньшего размера. В общем случае xcnt не должен превышать 256, в то время как full_size может достигать размеров всей памяти BlackFin.

<B> Важно! </B> Поля full_size и xcnt задаются в количестве 16-битных слов, а не 32-битных, так как шина HostDMA 16-битная.

В то время как запрос на ввод (передача от BlackFin в ПК) всегда выполняется полностью и в возвращенном дескрипторе full_size = 0, то на вывод ситуация иная. Если ПЛИС выполнит передачу только части блока данных, но при этом от ПК не будет новых данных, то будет записан дескриптор в out_lb с full_size равным количеству непереданных данных. При этом при поступлении новых данных будет продолжен обработываться незавершенный запрос и следующая запись в out_lb будет соответствовать тому же дескриптору, но уже с меньшим full_size. Это позволяет пользователю передавать данные на вывод не сплошным потоком, и BlackFin сможет их обработать, не дожидаясь, когда будут записаны все full_size/2 отсчетов.




Таким образом, алгоритм приема потока вывода выглядит следующим образом:
- При запуске потока прошивка вызывает функцию hdma_recv_start(), которая устанавливает выход PF15 в 0 --- разрешается поток на вывод
- При наличии места для приема данных вызывается функция hdma_recv_req_start() с указанием буфера --- функция заполняет дескриптор g_state.out[0] нужными значениями (full_size=size*2, xcnt=min(256, size*2), addr, valid=1, id) и изменяет состояние выхода PG6, чтобы сообщить ПЛИС о готовности нового запроса
- ПЛИС по этому сигналу, когда будет свободна шина HostDMA, считывает дескриптор из g_state.out[0]
- При наличии данных в памяти ПК на передачу и свободной шине HostDMA идет запись в память BlackFin по адресу g_state.out[0].addr данных из памяти ПК блоками размером не больше xcnt 16-битных слов.
- При передаче всех full_size слов или при отсутствии данных в памяти ПК на передачу записывается считанный до этого дескриптор с измененными полями full_size и addr по адресу &g_state.out_lb.
- По завершению этой записи в обработчике hdma_isr() прошивка определяет по g_state.out_lb.valid, что записан дескриптор, устанавливает g_state.out_lb.valid в 0, вычисляет обработанный размер и вызывает hdma_recv_done().
- hdma_recv_done() в l502_stream.c помечает данные как готовые к обработке. После из уже не из обработчика прерываний, а из основной программы, будет вызвана usr_out_proc_data() для обработки принятых данных.
- Если full_size=0, то дескриптор полностью обработан и можно переходить к следующему, иначе --- продолжается обмен, соответствующий данному дескриптору.
- По мере необходимости добавляются новые дескрипторы через hdma_recv_req_start(). Дожидаться завершения предыдущего не обязательно --- задания на прием данных ставятся в очередь. Только нужно проверять, что есть место в очереди через hdma_recv_req_rdy().
- При завершении потокового вывода вызывается hdma_recv_stop(), которая устанавливает PF15 в 1, что приводит к сбросу автомата передачи потока на вывод по HostDMA в ПЛИС.

Алгоритм передачи данных для потока ввода выглядит схожим образом:
- При запуске потока прошивка вызывает функцию hdma_send_start(), которая устанавливает выход PF14 в 0 --- разрешается поток на ввод
- При наличии блока данных на передачу необходимо вызвать hdma_send_req_start() с указанием буфера с данными --- функция заполняет дескриптор g_state.in[0] нужными значениями (full_size=size*2, xcnt=min(256, size*2), addr, valid=1, id) и изменяет состояние выхода PG5, чтобы сообщить ПЛИС о готовности нового запроса.
- ПЛИС по этому сигналу, когда будет свободна шина HostDMA, считывает дескриптор из g_state.in[0].
- При наличии места в памяти ПК на прием и свободной шине HostDMA идет чтение данных из памяти BlackFin, начиная с адреса g_state.in[0].addr,  блоками размером не больше xcnt 16-битных слов с последующей записью в память ПК.
- При передаче всех full_size слов записывается считанный до этого дескриптор с измененными полями full_size и addr по адресу &g_state.in_lb.
- По завершению этой записи в обработчике hdma_isr() прошивка определяет по g_state.in_lb.valid, что записан дескриптор, устанавливает g_state.in_lb.valid в 0, вычисляет обработанный размер и вызывает hdma_send_done().
- hdma_send_done() реализовано в l502_user_process.c.
- При передаче на вывод в обратно записанном дескрипторе full_size=0, что соответствует полностью обработанному дескриптору.
- По мере необходимости добавляются новые дескрипторы через hdma_send_req_start(). Дожидаться завершения предыдущего не обязательно --- задания на передачу данных ставятся в очередь. Только нужно проверить, что есть место в очереди через hdma_send_req_rdy().
- При завершении потокового ввода вызывается hdma_send_stop(), которая устанавливает PF14 в 1, что приводит к сбросу автомата приема потока на ввод по HostDMA в ПЛИС.


Прием потока данных по SPORT0{#sect_sport_recv}
==================================================================
В отличии от остальных интерфейсов для приема-передачи потоков данных, где обмен осуществляется через дескрипторы и может быть приостановлен, пока новый дескриптор не будет поставлен в очередь, прием синхронных данных от АЦП/DIN всегда осуществляется непрерывно со скоростью ввода этих данных.
Прием осуществляется 32-битными словами. При этом каждое 32-битное слово передается как два 16-битных, передаваемых параллельно --- одно по первичному каналу SPORT0, второе --- по вторичному. При приеме используется внешний сигнал начала кадра (RFS), который генерирует ПЛИС каждый раз при наличии нового принятого отсчета АЦП или DIN. Сигнал RFS должен быть явно разрешен с помощью установки бита \f$ $\bitref{BfRfsEn}{BF\_RFS\_EN}$ \f$ регистра  \f$ $\regref{OutSwapBfctl}{OUTSWAP\_BFCTL}$ \f$.

Для приема используется третий канал DMA BlackFin в режиме автобуфера. Прием данных происходит постоянно в буфер `f_sport_in_buf` размером #L502_SPORT_IN_BUF_SIZE. Сам буфер разделен на блоки, размер каждого из которых равен шагу прерывания. Этот шаг может быть установлен с помощью функции sport_in_set_step_size(). В штатной прошивке установка этого параметра осуществляется с ПК через команду #L502_BF_CMD_CODE_SET_PARAM с параметром #L502_BF_PARAM_IN_STEP_SIZE, но ничего не мешает изменять его из самой прошивки пока синхронные потоки не запущены.

Для реализации приема данных с указанным шагом используется 2D режим DMA, где размер по X равен размеру шага (умноженному на 2, т.к. используется  16-битный режим DMA), а по Y - количеству шагов, которое помещается в буфере на прием (должно быть не меньше 3). Таким образом, если размер буфера на прием не кратен шагу, то реально используется не весь буфер, а наибольший размер кратный шагу, но не превышающий размер буфера.

После приема данных, размер которых соответствует шагу прерывания, будет вызван обработчик isr_sport_dma_rx(), в котором обновляется размер принятых данных в буфере и проверяется переполнение. Т.к. прерывание возникает при завершении приема блока данных, когда уже начат прием следующего блока, то, чтобы не допустить порчи данных из-за переполнения буфера, необходимо, чтобы в момент прерывания было свободно для приема как минимум два блока. В противном случае, если к следующему прерыванию хотя бы еще один блок не освободится, то о переполнении прошивка узнает только в момент, когда часть буфера уже была повреждена (что может привести к тому, что будут обработаны испорченные данные). Таким образом, для надежного приема данных, если в прерывании обнаруживается, что свободно меньше двух блоков, то это считается переполнением.

По переполнению останавливается прием по интерфейсу SPORT0 и взводится специальный флаг. После этого обрабатываются все принятые, но необработанные данные в буфере, после чего в ПК посылается слово о том, что в данном месте было переполнение.

Управление приемом по SPORT0 осуществляется из функций управления потоками: при запуске синхронного ввода-вывода и разрешенных потоках на ввод выполняется функция sport_rx_start(), которая настраивает DMA, сбрасывает указатели в буфере на прием и разрешает прием по SPORT0. При останове синхронного ввода-вывода или запрете всех потоков на ввод выполняется останов приема по SPORT0 через sport_rx_stop().

Передача потока данных по SPORT0{#sect_sport_send}
==================================================================
Передача по SPORT0 данных для вывода на ЦАП и DOUT осуществляется во многом подобно тому, как происходит передача по HostDMA. Для этого также используется набор дескрипторов, которые можно поставить в очередь с помощью sport_tx_start_req() и узнать количество свободных дескрипторов в очереди с помощью sport_tx_req_rdy().

В отличие от HostDMA для этого используются стандартные дескрипторы DMA процессора BlackFin. Также не требуется отдельно запускать передачу по SPORT0 --- разрешение на передачу выполняется при добавлении первого дескриптора. Но для останова всех данных и освобождения всех дескрипторов существует функция sport_tx_stop().

Передача по SPORT0 аналогично приему осуществляется 32-битными словами в параллель двумя половинами по 16-бит --- одна по первичному каналу, вторая по вторичному. Также как и для приема необходимо разрешение генерации внешних TFS. Причем это выполняется в логике управления потоками при разрешении потоков на вывод. А постановка новых дескрипторов на передачу выполняется из пользовательской обработки.

Общая логика управления потоками{#sect_streams}
====================================================================
Логика управления потоками в штатной прошивке аналогична этой же логике в l502api:
- Каждый источник ввода-вывода (АЦП, DIN, 1-ый канал ЦАП, 2-ой канал ЦАП, DOUT) может быть настроен на синхронный потоковый режим с помощью функций stream_enable() и запрещен синхронный режим по нему с помощью stream_disable().
- Все разрешенные потоки запускаются одновременно с помощью функции streams_start(). Эта функция разрешает генерацию синхрочастоты, прием и передачу по HostDMA, прием и передачу по SPORT0 (если нужные потоки разрешены).
- Данные на вывод могут быть предварительно загружены, для чего функция stream_out_preload() инициализирует передачу по HostDMA без запуска синхронных сбора-выдачи.
- Во время запущенного синхронного ввода-вывода изменять настройки ввода-вывода нельзя (логическую таблицу, частоту сбора и т.д.).
- Во время сбора данных можно дополнительно разрешать или запрещать синхронные потоки (но пока не все варианты реализованы...)
- По вызову streams_stop() останавливается синхронный ввод-вывод и запрещаются все потоки данных по SPORT0 и HostDMA.

Как для потока ввода, так и для потока вывода в l502_stream.c выделен буфер для приема данных. Для отслеживания состояния данных для каждого буфера используются 3 указателя:
- Индекс, указывающий на слово сразу за последним принятым словом (f_sport_in_put_pos / f_hdma_out_put_pos). Обновляется в обработчике прерывания при приеме очередного блока данных.
- Индекс, указывающий на следующее слово для обработки (f_sport_in_proc_pos / f_hdma_out_proc_pos). Вместе с предыдущем определяет количество принятых, но еще не обработанных данных. Фоновая функция stream_proc() проверяет наличие необработанных данных и вызывает функцию пользовательской обработки: usr_in_proc_data() или usr_out_proc_data(). Эти функции возвращают количество обработанных данных, на которое и увеличивается индекс слова для обработки. Эти данные считаются обработанными, но буфер все еще занятым.
- Индекс, указывающий на следующее занятое слово (f_sport_in_get_pos / f_hdma_out_get_pos). Используется, чтобы определить, сколько места в буфере свободно для приема новых данных. Этот размер нужен для постановки новых дескрипторов на прием по HostDMA или для определения факта переполнения при приеме по SPORT0. Эти индексы обновляются при вызове функций stream_in_buf_free() / stream_out_buf_free() из пользовательских обработчиков.

Разграничение обработанных и занятых данных можно использовать, например в следующих случаях:
- Случай, когда еще нет возможности обработать данные, функция обработки может вернуть 0. Тогда в последующем она будет вызвана снова для обработки этих же данных (возможно с дополнительными данными, принятыми за интервал между вызовами). При этом функции обработки не нужно копировать данные для гарантии, что они не будет перезаписаны. Так например происходит в штатной прошивке, когда нет свободных дескрипторов для передачи принятых данных.
- Если обработка ведется заданными блоками, то функция может возвращать обработанный размер всегда кратный размеру блоку. При этом в дальнейшем необработанный неполный блок будет снова передан в функцию обработки при следующем вызове.


Форматы данных в потоке на ввод и на вывод{#sect_streams_format}
=======================================================================
Существует только один поток на ввод и один на вывод. Данные в потоке передаются в виде 32-битных слов. При этом в 32-битном слове, помимо самих данных закодировано и что это за данные (АЦП или DIN).

Определить, что за данные, можно по старшему байту принятого слова.
Ниже приведена таблица для определения какому типу данных принадлежит принятое слово из потока ввода:

Биты 31-24 | Значение
-----------| ------------------
1xxxxxxx   | Данные от АЦП
00000000   | Данные с цифровых входов
00000001   | Сообщения (от BF в ПК)
001xxxxx   | Резерв
01xxxxxx   | Пользовательские данные

Непосредственно от ПЛИС по SPORT0 приходят только данные от АЦП и цифровых входов. Сообщения могут генерироваться в прошивке BlackFin для уведомления программы ПК о событиях. Сейчас используется только одно сообщение --- сообщение о переполнении буфера. Штатная прошивка передает это сообщение при переполнении буфера SPORT0 на прием. При работе в режиме без DSP это сообщение генерируется аппаратно ПЛИС при переполнении внутреннего буфера DMA на ввод.

Данные от АЦП приходят в виде расширенного 24-битного формата в дополнительном коде, так как к ним уже аппаратно применены калибровочные коэффициенты.
Код #L502_ADC_SCALE_CODE_MAX соответствует напряжению равному границе данного диапазона (например, +10В, +2В и т.д.).

Данные от АЦП приходят в следующем формате:

31-24      | 23-0                     
-----------| --------------------------
11mmcccc   | dddddddddddddddddddddddd 

- d --- 24-битный скорректированный дополнительный код АЦП.
- с --- номер канал: "0" --- 1-ый или 17-ый, "15" --- 16-ый или 32-ой канал (в зависимости от режима).
- m --- режим измерения:
    - 0 --- дифференциальный
    - 1 --- первые 16 каналов с общей землей
    - 2 --- вторые 16 с общей землей
    - 3 --- собственный ноль


С цифровых линий данные приходят в следующем формате:

31-24     | 23-16    | 15 - 8   | 7 - 0
----------|----------|----------|---------
00000000  | 000000ss | dddddddd | dddddddd

- d --- значения цифровых линий
- s --- значение линий DI_SYN1 (16-ый бит) и DI_SYN2 (17-ый бит)


Для слов потока на вывод схожим образом по старшем битам определяется, для чего предназначены данные:

Биты 31-24 | 23-16    | 15 - 8   | 7 - 0    | Значение
-----------|----------|----------|----------|--------------
00000000   | 000000ee | dddddddd | dddddddd | Цифровой вывод (е - разрешение старшей и младшей половин)
01000000   | 00000000 | dddddddd | dddddddd | код для ЦАП1
10000000   | 00000000 | dddddddd | dddddddd | код для ЦАП2
110xxxxx   | xxxxxxxx | xxxxxxxx | xxxxxxxx | Резерв
111xxxxx   | xxxxxxxx | xxxxxxxx | xxxxxxxx | Пользователь-ские данные

Коды ЦАП в отличие от кодов АЦП не откалиброваны. Калибровку необходимо выполнять либо в ПО на ПК (что доступно в l502api), либо использовать коэффициенты из g_module_info.

Комбинации, помеченные как пользовательские данные, пользователь может использовать для передачи своих данных в общем потоке от DSP в ПК или от ПК в DSP. Эти комбинации не должны передаваться в ПЛИС по SPORT0.


Доступ к регистрам ПЛИС{#sect_fpga_regs}
=========================================
Прошивка имеет доступ к части регистров ПЛИС для настройки параметров ввода-вывода. BlackFin имеет доступ только к регистрам \f$ $\hyperref[tab:regIoHard]{IO\_HARD}$ \f$  и \f$ $\hyperref[tab:regIoArith]{IO\_ARITH}$ \f$ при включенном режиме DSP (доступ к этим регистрам с ПК по PCI-Express при этом запрещается). Все адреса при этом остаются теми же как и при работе с ними со стороны ПК (используются именно адреса 32-битных регистров, приведенные в данном документе, а не адреса памяти) и эти значения описаны в файле `l502_fpga_regs.h`.

Список регистров приведен в \f$ $\hyperref[sect:pciRegIoHard]{разделе \ref*{sect:pciRegIoHard}}$ \f$.


Для чтения и записи регистров используются функции fpga_reg_write() и fpga_reg_read().

При этом сам доступ идет по SPI-интерфейсу и осуществляется за четыре 16-битных цикла. BlackFin при этом является мастером. Ниже приведены данные, передаваемые и принимаемые при циклах записи и чтения регистра ПЛИС.

Цикл записи регистра выглядит следующим образом:

№ цикла SPI |    MOSI        |  MISO   |  Описание
------------|----------------|---------|--------
1           |11aaaaaaaaaaaaaa|    -    | Признак начала записи и адрес регистра
2           |00000000dddddddd|    -    |  Данные (биты 31-24)
3           |00000000dddddddd|    -    |  Данные (биты 15-8)
4           |00000000dddddddd|    -    |  Данные (биты 7-0)

Цикл чтения регистра выглядит следующим образом:

№ цикла SPI |    MOSI        |  MISO          |  Описание
------------|----------------|----------------|--------
1           |10aaaaaaaaaaaaaa|      -         | Признак начала чтения и адрес регистра
2           |        -       |      -         | Пустой цикл
3           |        -       |dddddddddddddddd| Данные (биты 31-16)
4           |        -       |dddddddddddddddd| Данные (биты 15-0)



Настройка параметров сбора данных{#sect_dsp_cfg}
=========================================

Как и для API верхнего уровня, прошивка BlackFin может устанавливать параметры сбора данных только в момент, когда не запущен синхронный ввод-вывод. В штатной прошивке, как и в API верхнего уровня, сперва задаются все параметры, после чего вызывается специальная функция (configure()), которая их непосредственно записывает в регистры ПЛИС. Сами параметры хранятся в структуре #g_set. Они могут быть заданы как командами из программы ПК при вызове `X502_Configure()`, так и изменены внутри самой прошивкой. Для изменения можно как напрямую изменять поля структуры #g_set, так и использовать функции из l502_param.h (params_set_lch(), params_set_adc_freq_div() и т.д.), которые дополнительно проверяют значения параметров. Сами параметры аналогичны используемым в API верхнего уровня (правда частоты сбора необходимо устанавливать вручную с помощью делителей и межкадровой задержки).

После изменения параметров из прошивки необходимо перед запуском сбора не забыть вызвать configure().


Информация о модуле{#sect_brd_info}
=========================================
Так как BlackFin не имеет доступа к регистрам EEPROM, то из прошивки нельзя напрямую узнать информацию о модуле, которая может понадобится:
- наличие опций (в данном случае может интересовать наличие ЦАП, т.к. DSP и гальваноразвязка должны быть)
- версия ПЛИС и PLDA (чтобы знать, можно ли полагаться на аппаратные возможности, которые могут быть введены в дальнейшем)
- калибровки ЦАП, чтобы выставить на ЦАП откалиброванные значения из прошивки BlackFin по каким либо условиям. В отличие от данных АЦП, которые приходят уже после аппаратной коррекции, к данным ЦАП нужно применять калибровочные коэффициенты программно. В случае передачи значений из программы ПК, калибровка может быть уже применена в ПК. В случае, если значения формируются внутри прошивки BlackFin, код должен быть скорректирован самой прошивкой.

Вся эта информация передается прошивке BlackFin программой ПК с помощью команд сразу после загрузки прошивки с помощью `X502_BfLoadFirmware()` или при вызове `X502_BfCheckFirmwareIsLoaded()`. Эта информация сохраняется в глобальной структуре #g_module_info.

\tableofcontents
