Протокол обмена между с модулем E502{#sect_e502proto}
=================================================

Общее описание протокола{#sect_e502proto_gen}
===============================
Данный раздел описывает протокол, по которому происходит обмен между ПК (либо иным устройством, управляющим работой E502, но далее в главе управляющее устройство будет называться ПК) и контроллером ARM Cortex-M4 модуля E502 через USB или Ethernet интерфейс. Данный раздел предназначен для пользователей, которые хотят управлять модулем без использования штатных библиотек.

Общий принцип работы протокола и набор команд (за исключением нескольких специальных) общие как при работе с модулем по USB, так и по Ethernet. В данном разделе будет описан общий принцип протокола, а в следующих --- как команды и данные передаются по определенному интерфейсу.

Протокол обмена подразумевает два канала для взаимодействия с E502:
- Канал для передачи команд.
- Канал для передачи потоковых данных.

Каждая команда описывается следующими параметрами:
- Код команды. 32-битное число, определяющее, какое действие выполняет команда, а также значение всех остальных параметров команды.
- Параметр команды. 32-битное число, значение которого зависит от кода команды.
- Данные на передачу. Блок данных произвольного размера для передачи от ПК в E502 (формат зависит от кода команды).
- Данные на прием. При посылке команды задается запрашиваемый размер блока данных на прием, а модуль в ответе возвращает блок данных размером не больше запрашиваемого (формат зависит от кода команды).

Весь обмен по командному каналу выполняется по принципу "Запрос" --- "Ответ".  На каждую команду модуль возвращает ответ, содержащий код возврата, определяющий успешность выполнения команды (0 при успешном выполнении, иначе ---  [код ошибки](@ref t_e502_cm4_errs)), и блок данных произвольного размера, но не превышающего размер, запрошенный в команде. 

Описание поддерживаемых команд приведено в разделе @ref sect_e502proto_cmd.

По каналу для передачи потоковых данных передается поток из 32-битных слов. Каждое слово в потоке имеет формат, описанный в разделе @ref sect_streams_format. При штатном режиме работы эти потоки используются для передачи данных синхронного ввода (АЦП, DIN) и синхронного вывода (ЦАП, DOUT), однако при написании своей прошивки сигнального процессора возможно передавать и пользовательские данные. 

По данному каналу передается два независимых потока --- одни на ввод (от модуля в ПК) и один на вывод (от ПК в модуль). 


Обычно сперва используется управляющий канал для получения информации о модуле, настройки модуля, управления запуском сбора данных. А уже после запуска сбора используется канал передачи потоковых данных.

Настройка параметров ввода-вывода выполняется путем прямой записи в регистры ПЛИС, описанные в \f$ $\hyperref[sect:pciRegIoHard]{разделе \ref*{sect:pciRegIoHard}}$ \f$, в котором также дается типичная последовательность записи при запуске и останове сбора данных.

Реализация протокола при работе по интерфейсу USB{#sect_e502proto_usb}
=================================================
При работе по USB передача команд осуществляется по управляющей конечной точке (Control Pipe) в виде управляющих запросов. Передача по USB накладывает следующие ограничения на команды:
- Код команды может быть только в диапазоне от 0 до 255 (поэтому все реально используемые команды используют код в данном диапазоне).
- Блок данных может передаваться только в одну сторону (на передачу или на прием). 
- Результат выполнения операции не может быть передан в ответе (управляющий запрос может завершится успешно или нет), поэтому в случае если запрос завершился с ошибкой для получения кода ошибки последней операции сделана [отдельная команда](@ref sec_e502proto_cmd_usb_last_err).

При этом в SETUP пакете передается следующая информация (в соответствии с главой 9.2  спецификации USB версии 2.0):
- в поле bmRequestType указывается направления передачи блока данных, тип запроса всегда Vendor, приемником всегда выступает устройство (Device). Т.е. код 0x40 при передаче данных в модуль и 0xC0 при приеме из модуля.
- поле bRequest задает код команды (от 0 до 255)
- в поле wValue передаются младшие 16 бит параметра команды
- в поле wIndex передаются старшие 16 бит параметра команды
- в поле wLength передается длина блока данных на прием или передачу (в зависимости от направления запроса).

Блок данных передается как данные управляющего запроса.

Для передачи потоков данных используются конечные точки типа Bulk. Модуль имеет одну конечную точку типа IN и одну конечную точку типа OUT.

Реализация протокола при работе по интерфейсу Ethernet{#sect_e502proto_eth}
=================================================
При работе с модулем по интерфейсу Ethernet протокол реализуется поверх транспортного протокола TCP стека TCP/IP. Для канала передачи команд и канала передачи потоковых данных используются отдельные TCP соединения (далее называемыми управляющим соединением и соединением передачи данных). Управляющее соединение и соединение передачи данных используют разные номера TCP портов:
- порт 11114 --- управляющее соединение
- порт 11115 --- соединение для передачи данных

Модуль может поддерживать одновременно несколько управляющих соединений, но одновременно может быть только одно установленное соединение для передачи данных. 

Возможен случай, когда ранее установленное соединение для передачи данных не было закрыто корректно (например, если зависла машина с которой установлено соединение или отключение кабеля Ethernet при непрямом соединении). В этом случае может оставаться открытое соединение для передачи данных, хотя реально оно уже недействительно. Для того, чтобы можно было открыть новое соединение для передачи данных, введена [специальная управляющая команда](@ref sec_e502proto_cmd_tcp_datacon_drop), по которой модуль разрывает текущее соединение для передачи данных, что позволяет установить новое соединение.

Таким образом обычно соединение устанавливается следующим образом:
- Клиент устанавливает управляющее соединение
- При необходимости выполняются команды получения информации о устройстве или любые другие команды.
- При необходимости обмена данными подается [команда разрыва предыдущего соединения для передачи данных](@ref sec_e502proto_cmd_tcp_datacon_drop), после чего устанавливается новое соединение для передачи данных
- По завершению работы оба соединения должны быть закрыты.

Обмен командами по управляющему соединению  выглядит следующим образом.
Для посылки управляющего запроса клиент передает последовательно (все передается младшим байтом вперед):
- Признак начала запроса. 32-битное число, которое должно быть всегда равно 0x314C5443.
- Код команды. 32-битное число.
- Параметр команды. 32-битное число.
- Размер блока данных на передачу в байтах. 32-битное число. Должно быть не больше 512.
- Размер блока данных на прием в байтах. 32-битное число. Должно быть не больше 512.
- Блок данных на передачу. Размер равен указанному до этого количеству байт.

По приему данного запроса модуль выполняет обработку команды и возвращает ответ, передавая последовательно:
- Признак начала ответа. 32-битное число, которое должно быть всегда равно 0x314C5443.
- Код завершения команды. 32-битное число, равное нулю при успешном завершении и [коду ошибки](@ref t_e502_cm4_errs) при ее возникновении..
- Размер переменного блока данных. 32-битное число. Размер меньше или равен запрашиваемому размеру блока на прием.
- Блок данных указанного размера.

Список управляющих команд{#sect_e502proto_cmd}
==========================================================

В данном разделе описаны пользовательские команды, передаваемые модулю по управляющему каналу. Если в описании не описано назначение параметра команда, значит это значение зарезервировано для дальнейшего использования и должно быть равно нулю. Если не описано назначение данных на передачи или прием, то данный блок для этой команды не используется и должен всегда передаваться или всегда принимается блок нулевого размера.

Команды доступа к регистрам ПЛИС{#sec_e502proto_cmd_fpga}
-----------------------------------------------

Команды предназначены для доступа к регистрам ввода-вывода из блоков IO_HARD и IO_ARITH для настройки параметров ввода-вывода. Регистры данных блоков описаны в в \f$ $\hyperref[sect:pciRegIoHard]{разделе \ref*{sect:pciRegIoHard}}$ \f$. В функциях используются абсолютные адреса с учетом адреса начала блока, как описано в разделе  @ref sect_reg_addrmap. Также переход в режим работы с сигнальным процессором выполняется через регистр BF_CTL блока BF_CONTROL (однако для обращения к памяти сигнального процессора прямая работа с этими регистрами не нужна, т.к. для этого сделаны специальные команды, ускоряющие выполнения этих операций).

### Чтение значения регистра ПЛИС{#sec_e502proto_cmd_fpga_reg_read} 
**Код команды**:  0x10

**Параметр команды**: младшие 16 бит --- абсолютный адрес регистра. Старшие 16 бит --- резерв (должны быть равны 0).

**Данные на прием**: 4 байта --- 32 битное прочитанное значение регистра.

**Описание**: Команда позволяет прочитать текущее значение регистра ПЛИС с заданным адресом.

### Запись значения регистра ПЛИС{#sec_e502proto_cmd_fpga_reg_write}
**Код команды**:  0x11

**Параметр команды**: Младшие 16 бит --- абсолютный адрес регистра. Старшие 16 бит --- резерв (должны быть равны 0).

**Данные на передачу**: 4 байта --- 32 битное значение, которое нужно записать в регистр.

**Описание**: Команда записывает значение в один из регистров ПЛИС. 


Команды управления передачей потоковых данных{#sec_e502proto_cmd_stream}
-----------------------------------------------------------------

Данные команды управляют передачей потоковых данных по соответствующему каналу. При этом поток данных на ввод и на вывод управляются отдельно (в параметре команду указано, к какому направлению передачи относится команда).

### Запуск обмена потоковыми данными{#sec_e502proto_cmd_stream_start}
**Код команды**:  0x12

**Параметр команды**: Младшие 16 бит --- резерв (должны быть равны 0). Старшие 16 бит --- номер канала передачи данных (0 --- на ввод из модуля, 1 --- на вывод). 

**Описание**:  Команда запускает обмен по каналу передачи данных в указанном направлении (обмен по каждому направлению запускается отдельной командой). При этом по сути эта команда только инициализирует канал передачи данных, т.е. при выполнении данной команды контроллер начинает ожидать данные синхронного ввода (с АЦП/DIN или DSP) и передачу всех обнаруженных данных в ПК по каналу передачи, либо ожидание от ПК данных на вывод и передача этих данных в очередь на вывод (или DSP). Сам же ввод-вывод данных АЦП, ЦАП и/или цифровых линий начинается по условию запуска синхронного ввода-вывода (и к этому моменту канал передачи данных должен быть уже проинициализирован данной командой)..

### Останов обмена потоковыми данными{#sec_e502proto_cmd_stream_stop}
**Код команды**:  0x13

**Параметр команды**: Младшие 16 бит --- резерв (должны быть равны 0). Старшие 16 бит --- номер канала передачи данных (0 --- на ввод из модуля, 1 --- на вывод). 

**Описание**:  Команда останавливает ранее запущенный обмен по каналу передачи данных в указанном направлении (обмен по каждому направлению останавливается отдельной командой).



### Установка шага передачи данных{#sec_e502proto_cmd_stream_step}
**Код команды**:  0x14

**Параметр команды**: Младшие 16 бит --- размер шага в 32-битных словах. Старшие 16 бит --- номер канала передачи данных (0 --- на ввод из модуля, 1 --- на вывод). 

**Описание**: Команда реализована только для канала ввода. Устанавливает рекомендуемый размер блока на передачу данных из модуля в ПК. Используется в первую очередь при обмене по USB для более оптимального выбора размера блока передачи. Модуль передает данные как только накопит указанный размер, либо по прошествии определенного времени от последней передачи. При обмене по Ethernet как правило нет необходимости явно указывать размер этого блока.


### Проверка, запущена ли обмен потоковыми данными{#sec_e502proto_cmd_stream_is_running}
**Код команды**:  0x15

**Параметр команды**: Младшие 16 бит --- резерв (должны быть равны 0).  Старшие 16 бит --- номер канала передачи данных (0 --- на ввод из модуля, 1 --- на вывод). 

**Данные на прием**: 1 байт, указывающий, запущена ли передача потоковых данных в данном направлении (0 --- нет, 1 --- запущена).

## Команды доступа к Flash-памяти модуля{#sec_e502proto_cmd_flash}

В данной памяти хранится информация о модуле, включая калибровочные коэффициенты, а также половина памяти выделена для пользователя, чтобы он мог ее использовать под свои задачи. Эти команды в модуле E502 используются вместо блока регистров ПЛИС EEPROM у L502, описанных в разделе \f$ $\hyperref[sect:pciRegFlash]{разделе \ref*{sect:pciRegFlash}}$ \f$. В этом разделе можно посмотреть информацию о распределении адресного пространства данной памяти, а также формат информации о модуле (в \f$ $\hyperref[sect:flashFormat]{подразделе \ref*{sect:flashFormat}}$ \f$).

### Чтение блока данных из Flash-памяти модуля{#sec_e502proto_cmd_flash_rd}
**Код команды**:  0x17

**Параметр команды**: Адрес во Flash-памяти, соответствующий началу блока

**Данные на прием**: Блок данных размером от 1 до 512 байт с содержимым flash-памяти, начиная с заданного адреса.

**Описание**: По данной команде контроллер вычитывает блок данных заданного размера по заданному адресу Flash-памяти и передает этот блок в ответе.

### Запись блока данных во Flash-память модуля{#sec_e502proto_cmd_flash_wr}
**Код команды**:  0x18

**Параметр команды**: Адрес во Flash-памяти, соответствующий началу блока.

**Данные на передачу**: Блок данных размером от 1 до 512 байт для записи во Flash-память.

**Описание**: По данной команде контроллер записывает принятый блок данных по заданному адресу Flash-памяти. Данная область должна быть [стерта](@ref sec_e502proto_cmd_flash_erase) и в нее также [разрешена запись](@ref sec_e502proto_cmd_flash_protect).

### Стирание блока данных во Flash-памяти модуля{#sec_e502proto_cmd_flash_erase}
**Код команды**:  0x19

**Параметр команды**: Адрес во Flash-памяти, соответствующий началу блока. Адрес должен быть кратен значению 4096.

**Данные на передачу**: 4 байта --- 32 битное число, задающее размер области памяти, которую нужно стереть. Размер должен быть кратен значению 4096.

**Описание**: По данной команде контроллер записывает принятый блок данных по заданному адресу Flash-памяти. Должно быть [разрешено изменение данной области](@ref sec_e502proto_cmd_flash_protect).

### Изменение уровня защиты Flash-памяти модуля{#sec_e502proto_cmd_flash_protect}
**Код команды**:  0x1A

**Параметр команды**: Уровень защиты. 0 --- вся Flash-память защищена от записи. 1 --- пользовательская область может быть изменена, остальная защищена.

**Описание**: Данная команда используется для разрешения или запрета изменения данных, записанных в пользовательскую область памяти.


## Команды управления работой сигнального процессора

### Передача части прошивки сигнального процессора{#sec_e502proto_cmd_dsp_firm_trans}
**Код команды**:  0x16

**Параметр команды**: Смещение блока от начала файла прошивки

**Данные на передачу**: Блок данных из прошивки сигнального процессора размером от 1 до 512 байт (из .ldr файла). 

**Описание**: Команда предназначена для передачи прошивки сигнального процессора из ПК в память контроллера ARM, чтобы потом ее загрузить в сигнальный процессор с помощью [отдельной команды](@ref sec_e502proto_cmd_bf_load). Файл прошивки передается блоками.

### Запись блока данных в память сигнального процессора{#sec_e502proto_cmd_bf_mem_wr}
**Код команды**:  0x20

**Параметр команды**: Адрес из адресного пространства BlackFin

**Данные на передачу**: Блок данных размером от 4 до 512 байт для записи в память BlackFin. Должен быть кратен 4.

**Описание**: Данная команда позволяет напрямую записать нужные данные в память сигнального процессора по нужному адресу.

### Чтение блока данных из памяти сигнального процессора{#sec_e502proto_cmd_bf_mem_rd}
**Код команды**:  0x21

**Параметр команды**: Адрес из адресного пространства BlackFin

**Данные на прием**: Блок данных размером от 4 до 512 байт, прочитанный из памяти BlackFin. Должен быть кратен 4.

**Описание**: Данная команда позволяет прочитать состояние памяти сигнального процессора по нужному адресу. Для корректного выполнения данной команды в сигнальный процессор уже должна быть загружена прошивка и он должен быть запущен.


### Загрузка прошивки сигнального процессора и запуск его работы {#sec_e502proto_cmd_bf_load}
**Код команды**:  0x22

**Описание**: По данной команде ARM контроллер модуля выполняет запись прошивки из своей памяти в сигнальный процессор и запуск работы сигнального процессора. Соответственно, перед данной командой прошивка сигнального процессора должна быть уже загружена в память контроллера с помощью [соответствующих команд](@ref sec_e502proto_cmd_dsp_firm_trans).



## Команды циклического вывода{#sec_e502proto_cmd_cycle}
### Начало загрузки циклического сигнала на вывод{#sec_e502proto_cmd_cycle_load}
**Код команды**:  0x26

**Параметр команды**: Размер загружаемого циклического сигнала в 32-битных отсчетах

**Описание**: Данная команда указывает контроллеру, что начата загрузка циклического сигнала заданного размера. Контроллер проверяет наличие места в своей памяти и начинает ждать от ПК заданное количество отсчетов по каналу передачи потоковых данных.

###  Установка ранее загруженного циклического сигнала на вывод{#sec_e502proto_cmd_cycle_setup}
**Код команды**:  0x27

**Параметр команды**: набор флагов (аналогичен набору флагов функции X502_OutCycleSetup() из x502api).

**Описание**: Команда подается по завершению загрузки данных циклического вывода и по ней контроллер переключает вывод с предыдущего сигнала на новый.

###  Останов циклического вывода{#sec_e502proto_cmd_cycle_stop}
**Код команды**:  0x28

**Параметр команды**: набор флагов (аналогичен набору флагов функции X502_OutCycleStop() из x502api).

**Описание**: Останов вывода ранее установленного циклического сигнала.

### Проверка, завершена ли установка или останов циклического сигнала{#sec_e502proto_cmd_cycle_check}
**Код команды**:  0x29

**Данные на прием**: 1 байт, равный 1, если установка завершена, или 0 -- в противном случае..


## Получение информации о модуле{#sec_e502proto_cmd_info}

### Чтение информации о модуле{#sec_e502proto_cmd_get_info}
**Код команды**:  0x80

**Данные на прием**: 192 байта с информацией:
- 32 байта --- строка с названием типа устройства (должна быть "Е502")
- 32 байта --- строка с серийным номером модуля
- 32 байта --- строка с версией прошивки ARM контроллера 
- 16 байт   --- строка с номером ревизии платы (резерв)
- 16 байт   --- строка с исполнением платы (резерв)
- 64 байта --- дополнительная информация (резерв)

### Чтение дополнительных флагов о модификации и состоянии модуля{#sec_e502proto_cmd_get_devflags}
**Код команды**:  0x25

**Данные на прием**: 4-х байтовое слово, содержащее 32 флага (биты 0 - 31), из которых имеют значение:
- бит 9 --- признак поддержки модулем интерфейса Ethernet
- бит 15 --- признак индустриального исполнения модуля
- бит 23 --- признак наличия успешно загруженной прошивки ПЛИС модуля. Состояние данного флага обновляется в случае успешной загрузки прошивки при старте модуля, а также при принудительной перезагрузке прошивки командой 0x24.

### Чтение режима работы модуля{#sec_e502proto_cmd_get_mode}
**Код команды**:  0x81

**Данные на прием**: 1 байт с указанием режима работы модуля. 2 --- рабочий режим, 1 --- режим загрузчика.

### Чтение строки с названием типа модуля{#sec_e502proto_cmd_get_name}
**Код команды**:  0x0B

**Данные на прием**: 32 байта ---  строка с названием типа устройства (должна быть "Е502").


## Команды для работы с сетевыми настройками устройства   {#sec_e502proto_cmd_ethcfg}
Данные команды имеют смысл только для модуля с Ethernet интерфейсом, однако сами команды могут выполняться по любому интерфейсу, что позволяет изменить конфигурацию сетевых настроек модуля даже в случае, если текущие настройки неизвестны, подключив модуль по USB интерфейсу.

### Чтение сетевых настроек модуля{#sec_e502proto_cmd_ethcfg_read}
**Код команды**:  0x1D

**Данные на прием**: 94 байта с сетевыми настройками:
- 4 байта --- формат настроек (должен быть равен 0)
- 4 байта --- набор битовых флагов:
   - бит 0 --- разрешение интерфейса Ethernet модуля
   - бит 1 --- разрешение автоматического получения IP-адреса (через DHCP или link-local)
   - бит 2 --- использовать пользовательский, а не заводской MAC-адрес
- 64 байта --- строка с именем экземпляра устройства в кодировке UTF-8 (используется при автоматическом обнаружении устройства в сети)
- 6 байт --- пользовательский MAC-адрес
- 12 байт --- ручные настройки статических параметров IPv4:
    - 4 байта --- IPv4 адрес устройства
    - 4 байта --- маска подсети
    - 4 батйа --- IPv4 адрес шлюза
- 2 байта --- TCP-порт для обмена командами 
- 2 байта --- TCP-порт для передачи данных


### Запись сетевых настроек модуля{#sec_e502proto_cmd_ethcfg_write}
**Код команды**:  0x1C

**Параметр команды**:  набор флагов:
- бит 0 --- признак изменения пароля защиты сетевых настроек от изменения. Если данный флаг установлен, то при успешном выполнении команды пароль защиты настроек будет изменен, иначе данные о новом пароле анализироваться не будут.

**Данные на передачу**: 
- 32 байта --- текущее значение пароля защиты изменения настроек. Символ с нулевым кодом является признаком конца строки. Если не будет совпадать с установленным ранее паролем (если не установлен --- пустая строка), то команда завершится с ошибкой
- 32 байта --- значение нового пароля для защиты изменения настроек, который будет установлен в случае успешной записи настроек (пустая строка означает сброс пароля). Имеет смысл, если только бит 0 в параметре команды установлен в 1, иначе эти 32 байта не имеют значения.
- 94 байта --- устанавливаемые сетевые настройками в формате, аналогичном команде чтения.

## Дополнительные команды  {#sec_e502proto_cmd_additional}

### Перезагрузка прошивки ПЛИС{#sec_e502proto_cmd_reload_fpga}
**Код команды**:  0x24

**Описание**: По данной команде контроллер производит принудительную перезагрузку ПЛИС  и повторную заливку прошивки из flash-памяти. В первую очередь предназначена для загрузки новой прошивки после ее обновления во flash-памяти.

### Команды заводского тестирования модуля {#sec_e502proto_cmd_test}
**Код команды**:  0x40 - 0x42

**Описание**: Данные команды предназначены для тестирования работы устройства при производстве и не предназначены для пользователей, поэтому в данном руководстве не приводится описание их параметров и назначение каждой отдельной команды.

## Дополнительные команды для работы по интерфейсу Ethernet{#sec_e502proto_cmd_tcp}
### Разрыв TCP-соединения для обмена потоком данных{#sec_e502proto_cmd_tcp_datacon_drop}
**Код команды**:  0x23

**Описание**: По данной команде, если есть незакрытое TCP-соединение для передачи данных, то модуль немедленно закрывает данное соединение. Если такого соединения нет, то просто ничего не выполняется. Соответственно, после выполнения       команды можно установить новое соединение  для передачи данных.


## Дополнительные команды для работы по интерфейсу USB{#sec_e502proto_cmd_usb}
### Получение кода ошибки предыдущего управляющего запроса{#sec_e502proto_cmd_usb_last_err}
**Код команды**:  0x82

**Данные на прием**:  4 байта с кодом ошибки предыдущего запроса.

**Описание**: Команда позволяет узнать код ошибки выполнения последнего управляющего запроса по USB (0, если был выполнен успешно), чтобы более точно определить причину ошибки. 

### Получение текущего скоростного режима работы интерфейса USB{#sec_e502proto_cmd_usb_get_speed}
**Код команды**:  0x06

**Данные на прием**:  1 байт с указанием текущей скорости  (0 --- Full Speed, 1 --- High Speed)

**Описание**: Команда позволяет узнать, какой режим скорости был согласован между модулем и хостом по USB шине. Для E502 основным является High Speed режим, режим Full Speed приводит к сильному ограничению скорости.
