Управление модулем L502 со стороны ПК по интерфейсу PCI-Express{#sect_pc_ctl}
==============================================================
Введение{#sect_pc_ctl_intro}
==============================================================

В данной главе описывается интерфейс между модулем L502 и персональным компьютером. Этот раздел в первую очередь предназначен для пользователей, пишущих свой драйвер и библиотеку для работы с модулем. Для пользователей, разрабатывающих свою прошивку для сигнального процессора BlackFin, из данной главы будет полезен в первую очередь \f$ $\hyperref[sect:pciRegIoHard]{раздел \ref*{sect:pciRegIoHard}}$ \f$, в котором приводится описание регистров управления вводом-выводом, так как в DSP-режиме этими регистрами управляет сигнальный процессор. 

Для модуля E502 из этого раздела справедлива информация по регистрам блока ввода-вывода из  \f$ $\hyperref[sect:pciRegIoHard]{раздела \ref*{sect:pciRegIoHard}}$ \f$ и структура информации во Flash-памяти из  \f$ $\hyperref[sect:flashFormat]{раздела \ref*{sect:flashFormat}}$ \f$. Остальная информация относится только к модулю L502.

Конфигурационные регистры{#sect_pci_cfg}
==============================================================
Управление модулем L502 со стороны ПК осуществляется через интерфейс PCI Express. При этом программная модель шины PCI Express полностью совместима с программной моделью PCI.

Как и любое PCI/PCI-Express устройство, модуль реализует набор конфигурационных регистров, который состоит из фиксированного заголовка (Header 0) и связного списка дополнительных свойств (Capabilities List).

Конфигурационные регистры используются для определения, что это за устройство (по регистрам VendorID и DevceID), для назначения ресурсов устройству (областей памяти, номеров прерываний) и для общих функций управления устройством. Как правило, запись в конфигурационные регистры выполняется BIOSом и операционной системой, и драйверу прямая запись в эти регистры не требуется.

Эти регистры стандартны и полностью описаны в <I> "PCI Local Bus Specification Revision 3.0" </I> в главе 6 --- <I> "Configuration Space" </I>. Дополнительные свойства специфичные для PCI Express описаны в <I> "PCI Express в PCI Express Specification 3.0" </I> в главе 7 <I> "Software Initialization and Configuration" </I>.

Значения регистров, специфичные именно для модуля L502:
- Идентификаторы VendorID = 0x1172, DeviceID=0x0502
- Используется один банк памяти, который может быть расположен в любом месте 64-битного адресного пространства (занимает 2 первых BAR-регистра)
- Реализованные свойства:
    - PCI Express Capability
    - MSI Capability
    - Power Managment Capability

Прерывания{#sect_pci_irq}
==============================================================
В модуле L502 реализовано два механизма генерации прерываний:
 - Эмуляция стандартного прерывания PCI INTA. Этот режим включен по-умолчанию и предназначен для систем без поддержки MSI. Прерывания срабатывают по уровню и разделяются несколькими устройствами, что приводит к необходимости при прерывании определять, какое именно устройство сгенерировало это прерывание.
 - Message Signaled Interrupt (MSI) --- поддерживаются в версиях Windows, начиная с Windows Vista, и в Linux, начиная с версии ядра 2.6.8. Для их настройки используются набор конфигурационных регистров "MSI Capability". При разрешении MSI стандартное INTA прерывание не используется. В MSI прерывание эмулируется записью заданного значения по заданному адресу. Адрес и значение задаются в регистрах из "MSI Capability" и определяются операционной системой или биосом. Такой вариант прерываний дает возможность каждому устройству выделить свой вектор прерывания, что позволяет ускорить обработку, так как не надо определять, кто является источником прерывания, так как при срабатывании прерывания выполняется только один обработчик. В отличие от INTA MSI соответствуют прерыванию по фронту, а не по уроню. Рекомендуется использовать MSI прерывание всегда, когда это возможно.
 
 В L502 используется только одно прерывание. Прерывание используется блоком DMA, чтобы сообщить, что блок данных был записан в память ПК или считан из нее. Для определения источника прерывания достаточно прочитать значение регистра \f$ $\regref{DmaIrq}{DMA\_IRQ}$ \f$.


Доступ к регистрам ПЛИС через память{#sect_pci_memory}
================================================================
Модуль L502 использует один регион памяти размером 16КБайт, который может быть спроецирован в любую область 64-битного адресного пространства (для задания адреса используются два первых BAR-регистра в конфигурационном пространстве). Назначение области памяти обычно выполняется биосом или операционной системой, а драйвер от уже как правило получает указатель на требуемую область в своем адресном пространстве с помощью функций, предоставляемых ОС.

Работа с модулем главным образом выполняется путем записи/чтения значений по определенным адресам этой области. При обращении к этой памяти, реально выполняется обращение к регистрам ПЛИС, с помощью которых и осуществляется управление модулем. Все регистры 32-битные В дальнейшем в качестве адреса регистра будет приведен номер 32-битного регистра. Так как в PCI и PCI-Express адресуемой единицей является байт, то для получения адреса регистра в памяти нужно к начальному адресу области памяти, выделенной модулю, прибавить адрес регистра умноженный на 4:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.c}
 mem_addr = mem_offs + 4*reg_addr
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Распределение адресного пространстава регистров ПЛИС{#sect_reg_addrmap}
----------------------------------------------------------------------------------------------------

Регистры в памяти поделены по своему назначению на блоки, каждый из которых имеет свой диапазон адресов:

Адреса регистров | Блок регистров | Описание
-----------------|----------------|-------------------
0x0000 - 0x00FF  | BF_CONTROL     | Управление доступом к DSP по HostDMA
0x0100 - 0x013F  | EEPROM         | Доступ к Flash-памяти
0x0140 - 0x017F  | DBG            | Регистры с отладочной информацией
0x0180 - 0x01FF  | -              | Резерв
0x0200 - 0x03FF  | IO_HARD        | Управление вводом-выводом
0x0400 - 0x04FF  | IO_ARITH       | Дополнительная обработка
0x0500 - 0x05FF  | -              | Резерв
0x0600 - 0x0FFF  | DMA            | Управление прямым доступом к памяти

В последующих разделах будут рассмотрены регистры всех этих блоков. При этом в дальнейшем номера регистров будут приводится относительно адреса начала блока (т.е. для получения абсолютного адреса регистра нужно к указанному относительному адресу добавить адрес начала блока).
