/** @defgroup async_io Асинхронный ввод-вывод */

/***************************************************************************//**
    @addtogroup async_io
    @{
    @file l502_async.h

    Файл содержит описания функций асинхронного ввода-вывода
 ******************************************************************************/

#ifndef L502_ASYNC_H_
#define L502_ASYNC_H_

#include <stdint.h>

/** Первый канал ЦАП при выводе через async_dac_out() */
#define L502_DAC_CH1 0
/** Второй канал ЦАП при выводе через async_dac_out() */
#define L502_DAC_CH2 1

/***************************************************************************//**
   @brief Асинхронный вывод на один из каналов ЦАП

   Функция выполняет асинхронный вывод кода на ЦАП
   @param[in] ch     Канал ЦАП (#L502_DAC_CH1 или #L502_DAC_CH2)
   @param[in] val    Код ЦАП (действительны только младшие 16 бит)
 ******************************************************************************/
void async_dac_out(uint8_t ch, int32_t val);

/***************************************************************************//**
   @brief Асинхронный вывод на цифровые линии

   Функция выполняет асинхронный вывод кода на цифровые линии с возможностью указать
   линии, которые не должны изменяться
   @param[in] val    биты 0-15 - значения линий на вывод + возможно перевести
                     половину портов в 3-е состояние с помощью флагов из
                     #t_l502_digout_word_flags
   @param[in] msk    Если в маске установлены некоторые биты, то соответствующие
                     биты из val не влияют, а сохраняются предыдущие значения
 ******************************************************************************/
void async_dout(uint32_t val, uint32_t msk);

#endif


/** @} */
