/*****************************************************************************
 * NewProject.c
 *****************************************************************************/

#include "l502_cdefs.h"
void l502_init(void);
#include "l502_global.h"
#include "l502_cmd.h"

void stream_proc(void);

/* g_state описывает область памяти, расположенную по фиксированным адресам.
 * Для расположения в начало банка A данных используем специальную секцию */
SECTION("board_state", volatile t_l502_board_state g_state);


int main(void) {
    /* Инициализация интерфейсов */
    l502_init();

    for (;;) {
        /* проверяем наличие команды от ПК и начинаяем
           обработку, если она есть */
        l502_cmd_check_req();
        /* обработка потоков данных */
        stream_proc();
    }

    return 0;
}
