#include <errno.h>
#include <stdio.h>
#include <stdint.h>
#ifndef _WIN32
    #include <unistd.h>
#endif

int rle_compress(FILE *in, FILE *out)
{
	uint8_t	t[129];
	int		i, keep;


	// algorithm
	t[0] = fgetc(in);
	while (!feof(in))
	{
		t[1] = fgetc(in);
		if (t[0] != t[1]) // uncompressible sequence
		{
			i = 1;
			if (!feof(in))
				do
					t[++i] = fgetc(in);
				while (!feof(in) && i < 128 && t[i] != t[i - 1]);
			if ((keep = t[i] == t[i - 1]))
				--i;
			if (fputc(i - 1, out) == EOF ||
				fwrite(t, sizeof(uint8_t), i, out) < (unsigned)i)
				break ; // write error
			t[0] = t[i];
			if (!keep)
				continue ; // size too large or EOF
		}
		// compressible sequence
		i = 2;
		do
			t[1] = fgetc(in);
		while (++i < 130 && t[0] == t[1] && !feof(in));
		if (fputc(i + 125, out) == EOF ||
			fputc(t[0], out) == EOF)
				break ; // write error
		t[0] = t[1];
	}

	// error handling
	i = ferror(in) || ferror(out);

	return (-i);
}

int	rle_extract(FILE *in, FILE *out)
{
	int		rle_seq, rle_val, rle_max;

	// algorithm
	rle_val = 0;
	while ((rle_seq = fgetc(in)) != EOF && (rle_val = fgetc(in)) != EOF)
	{
		rle_max = rle_seq + (rle_seq < 128 ? 1 : -126);
		while (rle_max--)
			if (fputc(rle_val, out) == EOF ||
				(rle_seq < 128 && rle_max && (rle_val = fgetc(in)) == EOF))
				break ; // write error
	}

	// error handling
	if (rle_val == EOF)
		errno = EBADMSG; // corrupted file
	rle_seq = errno || rle_seq != EOF || ferror(in) || ferror(out);

	return (-rle_seq);
}
