cmake_policy(PUSH)

cmake_minimum_required(VERSION 2.6)

if(LCARD_SDK_MAKE_INSTALLER)
    set(LPCIE_SDK_CONV_DIR ${CMAKE_CURRENT_BINARY_DIR}/sdk-conv)
    file(MAKE_DIRECTORY ${LPCIE_SDK_CONV_DIR})


    string(REGEX REPLACE "/" "\\\\" CONVERT_SRC_DIR ${CMAKE_CURRENT_SOURCE_DIR})
    string(REGEX REPLACE "/" "\\\\" CONVERT_DEST_DIR ${LPCIE_SDK_CONV_DIR})
    string(REGEX REPLACE "/" "\\\\" CMAKE_CURRENT_SOURCE_DIR_WIN ${LPCIE_SDK_SOURCE_DIR})

    string(REGEX REPLACE "/" "\\\\" LIBXML_BINARY ${LIBXML_BINARY})
    string(REGEX REPLACE "/" "\\\\" LIBXML_ICONV_BINARY ${LIBXML_ICONV_BINARY})
    string(REGEX REPLACE "/" "\\\\" LIBXML_ZLIB_BINARY ${LIBXML_ZLIB_BINARY})
    string(REGEX REPLACE "/" "\\\\" GACUTIL ${GACUTIL})
    string(REGEX REPLACE "/" "\\\\" BONJOUR_INSTALLERS_DIR ${BONJOUR_INSTALLERS_DIR})


    configure_file(${LPCIE_SDK_SOURCE_DIR}/win_installer/conv_cp1251.bat.in
                   ${LPCIE_SDK_BINARY_DIR}/conv_sdk_cp1251.bat @ONLY)


    add_custom_target(sdk-conv
        COMMAND cmd /c conv_sdk_cp1251.bat
        WORKING_DIRECTORY ${LPCIE_SDK_BINARY_DIR}
        )


    set(INSTALLER_NAME l502-e502-e16-sdk-setup-${LPCIE_SDK_VERSION}.exe)

    #конфигурируем NSIS-файл
    configure_file(${LPCIE_SDK_SOURCE_DIR}/win_installer/lpcie_install.nsi.in
                   ${LPCIE_SDK_BINARY_DIR}/lpcie_install.nsi @ONLY)


    #сборка установщика (включая все входящие утилиты) */
    add_custom_target(win-installer ALL     
        #по nsi файлу создаем установщик
        COMMAND ${NSIS_EXEC} ${LPCIE_SDK_BINARY_DIR}/lpcie_install.nsi

        DEPENDS driver_pci
        DEPENDS x502api_32
        DEPENDS x502api_64
        DEPENDS lpcieNet
        #DEPENDS x502api_pdf
        DEPENDS lxfw-update
        #DEPENDS x502_low_level_pdf
        DEPENDS sdk-conv
        WORKING_DIRECTORY ${LPCIE_SDK_BINARY_DIR}
        )
    #цель для сборки установщика без зависимостей
    add_custom_target(win-installer-nodep
        COMMAND ${NSIS_EXEC} ${LPCIE_SDK_BINARY_DIR}/lpcie_install.nsi
        WORKING_DIRECTORY ${LPCIE_SDK_BINARY_DIR}
        )


    if(NOT WIN_INSTALLER_NOSIGN)
        #подписываем установщик при неободимости
        add_custom_command(TARGET win-installer POST_BUILD
            COMMAND "${SIGNTOOL}" sign /v /n "${SIGN_COMPANY_NAME}" /t ${CERT_TIMESTAMP_URL} ${INSTALLER_NAME}
            WORKING_DIRECTORY ${PROJECT_BINARY_DIR}
        )
    endif(NOT WIN_INSTALLER_NOSIGN)
endif(LCARD_SDK_MAKE_INSTALLER)




cmake_policy(POP)
